/*
 * Decompiled with CFR 0.152.
 */
package com.qasymphony.qtest.bambooplugin.rest.service;

import com.qasymphony.qtest.bambooplugin.core.QTestConnector;
import com.qasymphony.qtest.bambooplugin.qtesttask.Configuration;
import com.qasymphony.qtest.bambooplugin.qtesttask.ConfigurationService;
import com.qasymphony.qtest.bambooplugin.rest.model.Project;
import com.qasymphony.qtest.bambooplugin.rest.model.Release;
import com.qasymphony.qtest.bambooplugin.utils.JsonUtils;
import java.util.List;

public class QTestProjectService {
    public List<Project> getProjects(String qTestUrl, String apiKey) {
        QTestConnector connector = new QTestConnector(qTestUrl, apiKey);
        String json = connector.getRaw("/api/v3/projects?assigned=true");
        return JsonUtils.toList(json, Project.class);
    }

    public List<Release> getReleases(String qTestUrl, String apiKey, Long projectId) {
        QTestConnector connector = new QTestConnector(qTestUrl, apiKey);
        String url = String.format("/api/v3/projects/%s/releases?includeClosed=true", projectId);
        String json = connector.getRaw(url);
        return JsonUtils.toList(json, Release.class);
    }

    public String getEnvironments(String qTestUrl, String apiKey, Long projectId) {
        QTestConnector connector = new QTestConnector(qTestUrl, apiKey);
        String url = String.format("/api/v3/projects/%s/settings/test-suites/fields?includeInactive=true", projectId);
        String json = connector.getRaw(url);
        return json;
    }

    public Configuration getCiConfiguration(String qTestUrl, String apiKey, Long projectId, String serverName, String projectName) {
        ConfigurationService configurationService = new ConfigurationService();
        return configurationService.get(qTestUrl, apiKey, String.valueOf(projectId), serverName, projectName, null);
    }
}

