/*
 * Decompiled with CFR 0.152.
 */
package com.qasymphony.qtest.bambooplugin.rest;

import com.qasymphony.qtest.bambooplugin.qtesttask.Configuration;
import com.qasymphony.qtest.bambooplugin.rest.model.Project;
import com.qasymphony.qtest.bambooplugin.rest.model.Release;
import com.qasymphony.qtest.bambooplugin.rest.service.QTestProjectService;
import com.qasymphony.qtest.bambooplugin.utils.JsonUtils;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/projects")
public class QTestRestResource {
    @GET
    @Produces(value={"application/json"})
    public Response getProjects(@QueryParam(value="qTestUrl") String qTestUrl, @HeaderParam(value="token") String apiKey) {
        QTestProjectService service = new QTestProjectService();
        List<Project> projects = service.getProjects(qTestUrl, apiKey);
        return Response.ok((Object)JsonUtils.toJson(projects)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{projectId}/releases")
    public Response getReleases(@QueryParam(value="qTestUrl") String qTestUrl, @HeaderParam(value="token") String apiKey, @PathParam(value="projectId") Long projectId) {
        QTestProjectService service = new QTestProjectService();
        List<Release> releases = service.getReleases(qTestUrl, apiKey, projectId);
        return Response.ok((Object)JsonUtils.toJson(releases)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{projectId}/environments")
    public Response getEnvironments(@QueryParam(value="qTestUrl") String qTestUrl, @HeaderParam(value="token") String apiKey, @PathParam(value="projectId") Long projectId) {
        QTestProjectService service = new QTestProjectService();
        String json = service.getEnvironments(qTestUrl, apiKey, projectId);
        return Response.ok((Object)json).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{projectId}/ci-setting")
    public Response getCiSetting(@QueryParam(value="qTestUrl") String qTestUrl, @HeaderParam(value="token") String apiKey, @PathParam(value="projectId") Long projectId, @PathParam(value="serverName") String serverName, @PathParam(value="projectName") String projectName) {
        QTestProjectService service = new QTestProjectService();
        Configuration configuration = service.getCiConfiguration(qTestUrl, apiKey, projectId, serverName, projectName);
        return Response.ok((Object)JsonUtils.toJson(configuration)).build();
    }
}

