/*
 * Decompiled with CFR 0.152.
 */
package com.qasymphony.qtest.bambooplugin.qtesttask;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.util.concurrent.NotNull;
import com.atlassian.util.concurrent.Nullable;
import com.qasymphony.qtest.bambooplugin.qtesttask.Configuration;
import com.qasymphony.qtest.bambooplugin.qtesttask.ConfigurationService;
import com.qasymphony.qtest.bambooplugin.utils.PluginUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class QTestTaskConfigurator
extends AbstractTaskConfigurator {
    private ConfigurationService configurationService = new ConfigurationService();
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private BandanaManager bandanaManager;

    public QTestTaskConfigurator(AdministrationConfigurationAccessor administrationConfigurationAccessor, BandanaManager bandanaManager) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.bandanaManager = bandanaManager;
    }

    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Configuration configuration;
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        String qTestUrl = params.getString("qtest_url");
        String apiKey = params.getString("qtest_apikey");
        String projectId = params.getString("qtest_project");
        String releaseId = params.getString("qtest_release");
        String environmentId = params.getString("qtest_environment");
        String testResultsDir = params.getString("test_file_pattern");
        boolean useTestResultDir = this.isUseFilePattern(params);
        boolean produceBuildResult = this.isProduceTestResults(params);
        String projectName = PluginUtils.getPlanKey(params.getString("planKey"));
        AdministrationConfiguration adminConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        String baseUrl = adminConfiguration.getBaseUrl();
        String ciid = PluginUtils.retrievePluginId(this.bandanaManager);
        try {
            configuration = this.configurationService.get(qTestUrl, apiKey, projectId, baseUrl, projectName, ciid);
        }
        catch (Exception e) {
            configuration = new Configuration();
        }
        configuration.setqTestUrl(qTestUrl);
        configuration.setApiKey(apiKey);
        configuration.setProjectId(this.parseLong(projectId));
        configuration.setReleaseId(this.parseLong(releaseId));
        configuration.setBambooProjectName(projectName);
        configuration.setBambooServer(baseUrl);
        configuration.setCiid(ciid);
        configuration.setEnvironmentId(this.parseLong(environmentId));
        configuration = this.configurationService.saveOrUpdate(configuration);
        config.put("qtest_url", qTestUrl);
        config.put("qtest_apikey", apiKey);
        config.put("qtest_project", projectId);
        config.put("qtest_release", releaseId);
        config.put("qtest_environment", environmentId);
        config.put("test_file_pattern", testResultsDir);
        config.put("use_file_pattern", String.valueOf(useTestResultDir));
        config.put("produce_build_result", String.valueOf(produceBuildResult));
        if (null != configuration) {
            config.put("qtest_configuration_id", String.valueOf(configuration.getId()));
        }
        return config;
    }

    private Long parseLong(String environmentId) {
        if (StringUtils.isNotEmpty((CharSequence)environmentId)) {
            return Long.valueOf(environmentId);
        }
        return null;
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("test_file_pattern", "**/**/TEST*.xml");
        this.putBambooContextToLookupSavedConfiguration(context);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        Map configuration = taskDefinition.getConfiguration();
        String qTestUrl = (String)configuration.get("qtest_url");
        String apiKey = (String)configuration.get("qtest_apikey");
        context.put("qtest_url", qTestUrl);
        context.put("qtest_apikey", apiKey);
        context.put("qtest_project", configuration.get("qtest_project"));
        context.put("qtest_release", configuration.get("qtest_release"));
        context.put("qtest_environment", configuration.get("qtest_environment"));
        context.put("qtest_configuration_id", configuration.get("qtest_configuration_id"));
        context.put("use_file_pattern", configuration.get("use_file_pattern"));
        String testFilePattern = (String)configuration.get("test_file_pattern");
        if (StringUtils.isEmpty((CharSequence)testFilePattern)) {
            testFilePattern = "**/**/TEST*.xml";
        }
        context.put("test_file_pattern", testFilePattern);
        context.put("produce_build_result", configuration.get("produce_build_result"));
        this.putBambooContextToLookupSavedConfiguration(context);
    }

    private boolean isUseFilePattern(@NotNull ActionParametersMap params) {
        return params.getBoolean("use_file_pattern");
    }

    private boolean isProduceTestResults(@NotNull ActionParametersMap params) {
        String produceBuildResultText = params.getString("produce_build_result");
        return null != produceBuildResultText ? Boolean.valueOf(produceBuildResultText) : false;
    }

    private void putBambooContextToLookupSavedConfiguration(Map<String, Object> context) {
        AdministrationConfiguration adminConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        String baseUrl = adminConfiguration.getBaseUrl();
        Plan plan = (Plan)context.get("plan");
        String planKey = PluginUtils.getPlanKey(plan.getPlanKey().getKey());
        context.put("bamboo_url", baseUrl);
        context.put("plan_key", planKey);
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForView(context, taskDefinition);
    }
}

