/*
 * Decompiled with CFR 0.152.
 */
package com.qasymphony.qtest.bambooplugin.qtesttask;

import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.build.test.TestReportCollector;
import com.atlassian.bamboo.build.test.junit.JunitTestReportCollector;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plugin.PluginIdentifier;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.qasymphony.qtest.bambooplugin.qtesttask.Configuration;
import com.qasymphony.qtest.bambooplugin.qtesttask.ConfigurationHolder;
import com.qasymphony.qtest.bambooplugin.qtesttask.ConfigurationService;
import com.qasymphony.qtest.bambooplugin.storage.TestResultStoreService;
import com.qasymphony.qtest.bambooplugin.testsubmission.TestSubmissionService;
import com.qasymphony.qtest.bambooplugin.testsubmission.TestSubmitResult;
import com.qasymphony.qtest.bambooplugin.utils.ExceptionHelper;
import com.qasymphony.qtest.bambooplugin.utils.Operation;
import com.qasymphony.qtest.bambooplugin.utils.OperationHelper;
import com.qasymphony.qtest.bambooplugin.utils.PluginLogger;
import com.qasymphony.qtest.bambooplugin.utils.PluginUtils;
import com.qasymphony.qtest.bambooplugin.utils.http.OperationException;

public class QTestTask
implements TaskType {
    private TestCollationService testCollationService;
    private TestResultStoreService testResultStoreService = new TestResultStoreService();
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private BandanaManager bandanaManager;
    private PluginAccessor pluginAccessor;

    public QTestTask(TestCollationService testCollationService, AdministrationConfigurationAccessor administrationConfigurationAccessor, BandanaManager bandanaManager, PluginAccessor pluginAccessor) {
        this.testCollationService = testCollationService;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.bandanaManager = bandanaManager;
        this.pluginAccessor = pluginAccessor;
    }

    public TaskResult execute(final TaskContext taskContext) throws TaskException {
        TaskResultBuilder resultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        try {
            this.beforeExecute(taskContext);
            final ConfigurationHolder configurationHolder = new ConfigurationHolder();
            try {
                OperationHelper.executeWithRetry(3, 30, new Operation(){

                    @Override
                    public void execute() throws Exception {
                        QTestTask.this.checkConfiguration(taskContext, configurationHolder);
                    }

                    @Override
                    public void handleException(Exception e) {
                        PluginLogger.addErrorLogEntry(taskContext, "Error when getting configuration", e);
                        PluginLogger.addLogEntry(taskContext, "Retry to get configuration in 30 seconds...");
                    }
                });
            }
            catch (OperationException e) {
                PluginLogger.addErrorLogEntry(taskContext, "Cannot get configuration", e);
            }
            if (null == configurationHolder.getConfiguration()) {
                throw new IllegalStateException("Cannot get configuration, stop qTest task.");
            }
            PluginLogger.addLogEntry(taskContext, "Collect test logs...");
            this.collectTests(taskContext);
            TestSubmitResult result = new TestSubmissionService().submit(taskContext, configurationHolder.getConfiguration());
            String planKey = PluginUtils.getPlanKey(taskContext.getBuildContext().getPlanKey());
            int buildNumber = taskContext.getBuildContext().getBuildNumber();
            this.testResultStoreService.store(result, taskContext.getWorkingDirectory(), planKey, buildNumber);
            if ("Failed".equals(result.getSubmitStatus())) {
                PluginLogger.addErrorLogEntry(taskContext, "Error when execute qTest task: " + result.getError());
                resultBuilder.failed();
            } else {
                resultBuilder.success();
            }
        }
        catch (Exception e) {
            PluginLogger.addErrorLogEntry(taskContext, "Error when execute qTest task", e);
            resultBuilder.failedWithError();
        }
        this.beforeExit(taskContext);
        return resultBuilder.build();
    }

    private void beforeExecute(TaskContext taskContext) {
        PluginLogger.addLogEntry(taskContext, "------------------------------------------------------------------------");
        PluginLogger.addLogEntry(taskContext, "Execute qTest task with qTest plugin version " + this.getVersion(taskContext));
    }

    private String getVersion(TaskContext taskContext) {
        String pluginKey = PluginUtils.getPluginKey(taskContext.getPluginKey());
        Plugin qtestPlugin = this.pluginAccessor.getPlugin(pluginKey);
        if (null != qtestPlugin) {
            PluginIdentifier pIdentifier = new PluginIdentifier(qtestPlugin);
            return pIdentifier.getVersion();
        }
        return "UNKNOWN_VERSION";
    }

    private void checkConfiguration(TaskContext taskContext, ConfigurationHolder configurationHolder) {
        PluginLogger.addLogEntry(taskContext, "Checking configuration...");
        ConfigurationMap conf = taskContext.getConfigurationMap();
        String qTestUrl = (String)conf.get((Object)"qtest_url");
        String apiKey = (String)conf.get((Object)"qtest_apikey");
        String projectId = (String)conf.get((Object)"qtest_project");
        AdministrationConfiguration adminConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        String baseUrl = adminConfiguration.getBaseUrl();
        String ciid = PluginUtils.retrievePluginId(this.bandanaManager);
        String projectName = PluginUtils.getPlanKey(taskContext.getBuildContext().getPlanKey());
        PluginLogger.addLogEntry(taskContext, "Configuration Id: " + ciid);
        ConfigurationService confService = new ConfigurationService();
        Configuration configuration = null;
        boolean planKeyHasIndex = PluginUtils.hasIndexInKey(projectName);
        configuration = planKeyHasIndex ? this.handleConfigurationWhenUsingBranch(taskContext, confService, qTestUrl, apiKey, projectId, baseUrl, ciid, projectName) : confService.get(qTestUrl, apiKey, projectId, baseUrl, projectName, ciid);
        if (null == configuration) {
            configuration = confService.get(qTestUrl, apiKey, projectId, baseUrl, projectName, null);
        }
        if (null == configuration) {
            throw new IllegalStateException("Cannot find task's configuration. May be some error has been occurred in qTest or Could you please check you qTest task's configuration or re-configure qTest task.");
        }
        configuration.setApiKey(apiKey);
        configuration.setqTestUrl(qTestUrl);
        configuration.setCiid(ciid);
        configuration = confService.saveOrUpdate(configuration);
        configurationHolder.setConfiguration(configuration);
    }

    private Configuration handleConfigurationWhenUsingBranch(TaskContext taskContext, ConfigurationService confService, String qTestUrl, String apiKey, String projectId, String baseUrl, String ciid, String projectName) {
        Configuration conf;
        Configuration planConf;
        String planKey = PluginUtils.removeIndexFromKey(projectName);
        try {
            planConf = confService.get(qTestUrl, apiKey, projectId, baseUrl, planKey, ciid);
        }
        catch (Exception e) {
            ExceptionHelper.handleException(e, taskContext);
            return null;
        }
        try {
            conf = confService.get(qTestUrl, apiKey, projectId, baseUrl, projectName, ciid);
        }
        catch (Exception e) {
            conf = null;
        }
        if (null == conf) {
            conf = new Configuration();
            conf.setBambooProjectName(projectName);
            conf.setBambooServer(baseUrl);
            conf.setCiid(ciid);
        }
        conf.setqTestUrl(qTestUrl);
        conf.setApiKey(apiKey);
        conf.setProjectId(planConf.getProjectId());
        conf.setEnvironmentId(planConf.getEnvironmentId());
        conf.setReleaseId(planConf.getReleaseId());
        conf = confService.saveOrUpdate(conf);
        return conf;
    }

    private void beforeExit(TaskContext taskContext) {
        PluginLogger.addLogEntry(taskContext, "------------------------------------------------------------------------");
    }

    private void collectTests(TaskContext taskContext) {
        String filePattern = "**/**/TEST*.xml";
        ConfigurationMap confMap = taskContext.getConfigurationMap();
        if (confMap.getAsBoolean("use_file_pattern")) {
            filePattern = (String)confMap.get((Object)"test_file_pattern");
        }
        JunitTestReportCollector testCollector = new JunitTestReportCollector();
        this.testCollationService.collateTestResults(taskContext, filePattern, (TestReportCollector)testCollector);
    }
}

