/*
 * Decompiled with CFR 0.152.
 */
package com.qasymphony.qtest.bambooplugin.core;

import com.qasymphony.qtest.bambooplugin.core.AccessDeniedException;
import com.qasymphony.qtest.bambooplugin.core.OauthToken;
import com.qasymphony.qtest.bambooplugin.core.QTestAccessTokenHolder;
import com.qasymphony.qtest.bambooplugin.core.TokenStatus;
import com.qasymphony.qtest.bambooplugin.utils.JsonUtils;
import com.qasymphony.qtest.bambooplugin.utils.ResponseEntity;
import com.qasymphony.qtest.bambooplugin.utils.http.ClientRequestException;
import com.qasymphony.qtest.bambooplugin.utils.http.HttpClientUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public class QTestConnector {
    private static final String BAMBOO_AUTHORIZATION = "Basic YmFtYm9vOldGZGlXWHY4a3lhdnlQNDFJQnY1N3hSMVdNUHBtT2Ex";
    private String url;
    private String apiKey;

    public QTestConnector(String url, String apikey) {
        this.url = url;
        this.apiKey = apikey;
    }

    public QTestConnector(String url) {
        this(url, null);
    }

    public <T> T get(String path, Class<T> resultType) {
        return this.get(path, this.buildHeaders(), resultType);
    }

    private <T> T get(String path, Map<String, String> headers, Class<T> resultType) {
        try {
            ResponseEntity response = HttpClientUtils.get(this.processUri(path), headers);
            return this.checkResponse(response, resultType);
        }
        catch (ClientRequestException e) {
            this.wrapException(e);
            return null;
        }
    }

    public String getRaw(String path) {
        ResponseEntity response = this.getResponse(path, this.buildHeaders());
        return this.checkRawResponse(response);
    }

    private ResponseEntity getResponse(String path, Map<String, String> headers) {
        try {
            return HttpClientUtils.get(this.processUri(path), headers);
        }
        catch (ClientRequestException e) {
            this.wrapException(e);
            return null;
        }
    }

    private <T> T checkResponse(ResponseEntity response, Class<T> resultType) {
        String body = this.checkRawResponse(response);
        if (null == body) {
            return null;
        }
        return JsonUtils.toObject(body, resultType);
    }

    private String checkRawResponse(ResponseEntity response) {
        if (null == response) {
            return null;
        }
        String body = response.getBody();
        int statusCode = response.getStatusCode();
        if (200 == statusCode || statusCode == 201) {
            return body;
        }
        if (401 == statusCode) {
            throw new AccessDeniedException(body);
        }
        throw new IllegalStateException("Error while connect to qTest: " + body);
    }

    public <T> T put(String path, Object data, Class<T> resultType) {
        try {
            ResponseEntity response = HttpClientUtils.put(this.processUri(path), this.buildHeaders(), JsonUtils.toJson(data));
            return this.checkResponse(response, resultType);
        }
        catch (ClientRequestException e) {
            this.wrapException(e);
            return null;
        }
    }

    private <T> T post(String path, Object data, Map<String, String> headers, Class<T> resultType) {
        try {
            ResponseEntity response = HttpClientUtils.post(this.processUri(path), headers, JsonUtils.toJson(data));
            return this.checkResponse(response, resultType);
        }
        catch (ClientRequestException e) {
            this.wrapException(e);
            return null;
        }
    }

    public <T> T post(String path, Object data, Class<T> resultType) {
        return this.post(path, data, this.buildHeaders(), resultType);
    }

    public TokenStatus getTokenStatus(String token) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", token);
        return this.get("/oauth/status", headers, TokenStatus.class);
    }

    public String refreshAccessToken() {
        String uri = String.format("/oauth/token?grant_type=refresh_token&refresh_token=%s", this.apiKey);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", BAMBOO_AUTHORIZATION);
        OauthToken token = this.post(uri, null, headers, OauthToken.class);
        return "bearer " + token.getAccessToken();
    }

    private void wrapException(ClientRequestException e) {
        throw new RuntimeException("Exception when connect to qTest", e);
    }

    private String processUri(String path) {
        return this.url + path;
    }

    private Map<String, String> buildHeaders() {
        Assert.notNull((Object)this.url, (String)"qTest URL cannot be null");
        Assert.notNull((Object)this.apiKey, (String)"qTest API Key cannot be null");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Authorization", QTestAccessTokenHolder.getInstance(this.url, this.apiKey).getAccessToken());
        map.put("Content-Type", "application/json");
        return map;
    }
}

