/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.findings.bamboo;

import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.build.test.TestReportCollector;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.v2.build.CurrentResult;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.parasoft.findings.bamboo.ReportCollector;
import javax.inject.Inject;

public class ReportParserTask
implements TaskType {
    private final TestCollationService testCollationService;

    @Inject
    public ReportParserTask(@ComponentImport TestCollationService testCollationService) {
        this.testCollationService = testCollationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskResult execute(TaskContext taskContext) throws TaskException {
        ErrorMemorisingInterceptor errorLines = ErrorMemorisingInterceptor.newInterceptor();
        taskContext.getBuildLogger().getInterceptorStack().add((LogInterceptor)errorLines);
        String filePattern = (String)taskContext.getConfigurationMap().get((Object)"testResultsDirectory");
        boolean pickupOutdatedFiles = Boolean.parseBoolean((String)taskContext.getConfigurationMap().get((Object)"pickupOutdatedFiles"));
        try {
            this.testCollationService.collateTestResults(taskContext, filePattern, (TestReportCollector)new ReportCollector(), pickupOutdatedFiles);
            TaskResult taskResult = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkTestFailures().build();
            return taskResult;
        }
        finally {
            CurrentResult currentResult = taskContext.getCommonContext().getCurrentResult();
            currentResult.addBuildErrors(errorLines.getErrorStringList());
        }
    }
}

