/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.findings.bamboo;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskTestResultsSupport;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReportParserConfigurator
extends AbstractTaskConfigurator
implements TaskTestResultsSupport {
    private static final String DEFAULT_REPORT_LOCATION = "**/rep*.xml";
    private static final List<String> FIELD_KEYS = Arrays.asList("testResultsDirectory", "pickupOutdatedFiles");
    private final I18nResolver i18nResolver;

    @Inject
    public ReportParserConfigurator(@ComponentImport I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        for (String key : FIELD_KEYS) {
            config.put(key, params.getString(key));
        }
        return config;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("testResultsDirectory", DEFAULT_REPORT_LOCATION);
        context.put("pickupOutdatedFiles", Boolean.FALSE);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        for (String key : FIELD_KEYS) {
            context.put(key, taskDefinition.getConfiguration().get(key));
        }
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String reportLocation = params.getString("testResultsDirectory");
        if (reportLocation == null || reportLocation.trim().length() == 0) {
            errorCollection.addError("testResultsDirectory", this.i18nResolver.getText("report.location.pattern.error"));
        }
    }

    public boolean taskProducesTestResults(TaskDefinition taskDefinition) {
        return true;
    }
}

