/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.findings.bamboo;

import com.atlassian.bamboo.build.test.TestCollectionResult;
import com.atlassian.bamboo.build.test.TestCollectionResultBuilder;
import com.atlassian.bamboo.build.test.TestReportCollector;
import com.atlassian.bamboo.build.test.junit.JunitTestResultsParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import org.apache.log4j.Logger;
import org.fusesource.hawtbuf.ByteArrayInputStream;

public class ReportCollector
implements TestReportCollector {
    private static final Logger log = Logger.getLogger(ReportCollector.class);
    private static final XsltErrorListener xsltErrorListener = new XsltErrorListener();
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    public TestCollectionResult collect(File file) throws Exception {
        ReportType reportType = this.getReportType(file);
        if (reportType == null) {
            log.info((Object)("Skipping non-Parasoft report: " + file.getAbsolutePath()));
            return new TestCollectionResultBuilder().build();
        }
        try (InputStream stream = this.getInputStream(file, reportType.getXsl());){
            JunitTestResultsParser parser = new JunitTestResultsParser();
            parser.parse(stream);
            TestCollectionResult testCollectionResult = new TestCollectionResultBuilder().addSuccessfulTestResults((Collection)parser.getSuccessfulTests()).addFailedTestResults((Collection)parser.getFailedTests()).addSkippedTestResults((Collection)parser.getSkippedTests()).build();
            return testCollectionResult;
        }
    }

    private InputStream getInputStream(File file, String xslFile) throws SaxonApiException, FileNotFoundException {
        StreamSource xml = new StreamSource(new FileInputStream(file));
        StreamSource xsl = new StreamSource(this.getClass().getResourceAsStream(xslFile));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Processor processor = new Processor(false);
        XsltCompiler compiler = processor.newXsltCompiler();
        XsltExecutable executable = compiler.compile((Source)xsl);
        Serializer target = processor.newSerializer((OutputStream)baos);
        Xslt30Transformer transformer = executable.load30();
        transformer.setErrorListener((ErrorListener)xsltErrorListener);
        transformer.transform((Source)xml, (Destination)target);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public Set<String> getSupportedFileExtensions() {
        return new HashSet<String>(Collections.singleton("xml"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReportType getReportType(File from) throws XMLStreamException {
        StreamSource xml = new StreamSource(from);
        XMLEventReader reader = null;
        try {
            reader = xmlInputFactory.createXMLEventReader(xml);
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                switch (event.getEventType()) {
                    case 1: {
                        ReportType reportType;
                        String toolName = null;
                        StartElement startElement = event.asStartElement();
                        Iterator<Attribute> attributes = startElement.getAttributes();
                        while (attributes.hasNext()) {
                            Attribute attribute = attributes.next();
                            String name = attribute.getName().getLocalPart();
                            if (!"toolName".equals(name)) continue;
                            toolName = attribute.getValue();
                            break;
                        }
                        if (toolName != null) {
                            reportType = "SOAtest".equals(toolName) ? ReportType.SOATEST : ReportType.ANALYZERS;
                            return reportType;
                        }
                        reportType = null;
                        return reportType;
                    }
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException e) {
                    log.warn((Object)e);
                }
            }
        }
        return null;
    }

    private static enum ReportType {
        SOATEST("soatest-xunit.xsl"),
        ANALYZERS("xunit.xsl");

        private final String xsl;

        private ReportType(String xsl) {
            this.xsl = xsl;
        }

        String getXsl() {
            return this.xsl;
        }
    }

    private static class XsltErrorListener
    implements ErrorListener {
        private XsltErrorListener() {
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            log.warn((Object)exception);
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
            log.error((Object)exception);
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            log.fatal((Object)exception);
        }
    }
}

