/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.findings.bamboo;

import com.atlassian.bamboo.build.BuildDefinitionForBuild;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanPredicates;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.apache.log4j.Logger;

@ExportAsService
@BambooComponent
public class FindingsUpgradeTask
implements PluginUpgradeTask {
    private static final Logger log = Logger.getLogger(FindingsUpgradeTask.class);
    private final PlanManager planManager;

    @Inject
    public FindingsUpgradeTask(@BambooImport PlanManager planManager) {
        this.planManager = planManager;
    }

    public int getBuildNumber() {
        return 1;
    }

    public String getShortDescription() {
        return "Upgrades Parasoft Findings configuration.";
    }

    public Collection<Message> doUpgrade() throws Exception {
        log.info((Object)"upgrading task configurations");
        this.updatePlans();
        return Collections.emptySet();
    }

    private void updatePlans() {
        int numberOfChains = this.planManager.getPlanCount(Chain.class);
        for (int i = 0; i < numberOfChains; i += 100) {
            int firstResult = i;
            this.planManager.getAllPlans(Chain.class, firstResult, 100).stream().filter(PlanPredicates::planIsMaster).flatMap(plan -> plan.getAllJobs().stream()).forEach(this::upgradeJob);
        }
    }

    private void upgradeJob(Job job) {
        BuildDefinitionForBuild buildDefinitionXml = job.getBuildDefinitionXml();
        if (buildDefinitionXml == null) {
            return;
        }
        String xmlData = buildDefinitionXml.getXmlData();
        if (xmlData == null) {
            return;
        }
        boolean modify = false;
        if (xmlData.contains("parasoftSOAtest9xReportParserTask")) {
            xmlData = xmlData.replace("parasoftSOAtest9xReportParserTask", "parasoftReportParserTask");
            modify = true;
        }
        if (xmlData.contains("parasoftAnalyzers10xReportParserTask")) {
            xmlData = xmlData.replace("parasoftAnalyzers10xReportParserTask", "parasoftReportParserTask");
            modify = true;
        }
        if (modify) {
            log.info((Object)("updating job: " + job.getPlanKey()));
            buildDefinitionXml.setXmlData(xmlData);
            this.planManager.savePlan((Plan)job);
        }
    }

    public String getPluginKey() {
        return "com.parasoft.parasoft-findings-bamboo";
    }
}

