/*
 * Decompiled with CFR 0.152.
 */
package com.netsparker.tasks;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.netsparker.ConfigManager;
import com.netsparker.model.ScanType;
import com.netsparker.model.WebsiteModelRequest;
import com.netsparker.utility.AppCommon;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetsparkerCloudScanTaskConfigurator
extends AbstractTaskConfigurator {
    private ConfigManager configManager = new ConfigManager();

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        try {
            this.populateForAll(context);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        Map existingConfiguration = taskDefinition.getConfiguration();
        try {
            this.populateForAll(context);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        context.put("netsparkerCloudScanType", existingConfiguration.get("netsparkerCloudScanType"));
        context.put("netsparkerCloudWebsiteID", existingConfiguration.get("netsparkerCloudWebsiteID"));
        context.put("netsparkerCloudProfileID", existingConfiguration.get("netsparkerCloudProfileID"));
        ErrorCollection er = this.configManager.getErrorCollection();
        if (er != null && er.getTotalErrors() > 0) {
            context.put("hideErrorDiv", "no");
            Map fieldErrors = er.getFieldErrors();
            if (!fieldErrors.isEmpty()) {
                for (Map.Entry st : fieldErrors.entrySet()) {
                    context.put((String)st.getKey() + "Error", ((List)st.getValue()).iterator().next());
                }
            }
        } else {
            context.put("hideErrorDiv", "");
        }
    }

    private void populateForAll(@NotNull Map<String, Object> context) throws MalformedURLException, URISyntaxException {
        WebsiteModelRequest websiteModelRequest = new WebsiteModelRequest(this.configManager.getApiUrl(), this.configManager.getApiToken());
        if (websiteModelRequest.HasError()) {
            if (!this.configManager.hasCredentials()) {
                context.put("netsparkerCloudErrorMessage", "Please, validate your credentials from Netsparker Enterprise global settings.");
            } else {
                context.put("netsparkerCloudErrorMessage", websiteModelRequest.getErrorMessage());
            }
        } else {
            String websitesJsonModel = websiteModelRequest.getWebsitesJsonModel();
            if (websiteModelRequest.HasError()) {
                String errorMessage = websiteModelRequest.getErrorMessage() == null ? "Unable to retrieve scan settins." : websiteModelRequest.getErrorMessage();
                context.put("netsparkerCloudErrorMessage", errorMessage);
            } else {
                context.put("netsparkerCloudWebsitesJsonModel", websitesJsonModel);
                context.put("netsparkerCloudHideWebsiteList", this.configManager.getHideWebsiteList());
            }
        }
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String websiteIDString;
        super.validate(params, errorCollection);
        if (!AppCommon.IsUrlValid(this.configManager.getApiUrl())) {
            errorCollection.addError("netsparkerCloudServerURL", "Server URL is not valid.");
        }
        if (AppCommon.IsNullOrEmpty(this.configManager.getApiToken())) {
            errorCollection.addError("netsparkerCloudApiToken", "Api token is not valid.");
        }
        String scanTypeString = params.getString("netsparkerCloudScanType");
        boolean isScanTypeValid = true;
        ScanType scanType = ScanType.FullWithPrimaryProfile;
        try {
            scanType = ScanType.valueOf(scanTypeString);
        }
        catch (Exception ex) {
            isScanTypeValid = false;
        }
        if (!isScanTypeValid) {
            errorCollection.addError("netsparkerCloudScanType", "Scan type is not valid.");
        }
        if (!AppCommon.IsGUIDValid(websiteIDString = params.getString("netsparkerCloudWebsiteID"))) {
            errorCollection.addError("netsparkerCloudWebsiteID", "Website is not valid.");
        }
        boolean isProfileRequired = scanType != ScanType.FullWithPrimaryProfile;
        String profileIDString = params.getString("netsparkerCloudProfileID");
        if (isProfileRequired && !AppCommon.IsGUIDValid(profileIDString)) {
            errorCollection.addError("netsparkerCloudProfileID", "Scan profile is not valid.");
        }
        this.configManager.setErrorCollection(errorCollection);
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("netsparkerCloudScanType", params.getString("netsparkerCloudScanType"));
        config.put("netsparkerCloudWebsiteID", params.getString("netsparkerCloudWebsiteID"));
        config.put("netsparkerCloudProfileID", params.getString("netsparkerCloudProfileID"));
        config.put("netsparkerCloudHideWebsiteList", params.getString("netsparkerCloudHideWebsiteList"));
        return config;
    }
}

