/*
 * Decompiled with CFR 0.152.
 */
package com.netsparker.tasks;

import com.atlassian.bamboo.author.AuthorContext;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.spring.container.ContainerManager;
import com.netsparker.ConfigManager;
import com.netsparker.model.ScanRequest;
import com.netsparker.model.ScanRequestResult;
import com.netsparker.model.VCSCommit;
import com.netsparker.utility.AppCommon;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.http.HttpResponse;

public class NetsparkerCloudScanTask
implements TaskType {
    private BuildLogger buildLogger;
    private ConfigManager configManager = new ConfigManager();
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;

    @Inject
    public NetsparkerCloudScanTask(@ComponentImport AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public AdministrationConfiguration getAdministrationConfiguration() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration();
    }

    public Map<String, VariableDefinitionContext> getCustomVariables(TaskContext taskContext) {
        CustomVariableContext customVariableContext = (CustomVariableContext)ContainerManager.getComponent((String)"customVariableContext");
        return customVariableContext.getVariableContexts();
    }

    public TaskResult execute(TaskContext taskContext) throws TaskException {
        this.buildLogger = taskContext.getBuildLogger();
        TaskResult taskResult = this.ScanRequestHandler(taskContext);
        this.buildLogger = null;
        return taskResult;
    }

    private TaskResult ScanRequestHandler(TaskContext taskContext) throws TaskException {
        TaskResultBuilder builder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed();
        Map<String, VariableDefinitionContext> customVariables = this.getCustomVariables(taskContext);
        ConfigurationMap configurationMap = taskContext.getConfigurationMap();
        String serverURL = this.configManager.getApiUrl();
        String apiToken = this.configManager.getApiToken();
        String scanType = (String)configurationMap.get((Object)"netsparkerCloudScanType");
        String websiteId = (String)configurationMap.get((Object)"netsparkerCloudWebsiteID");
        String profileId = (String)configurationMap.get((Object)"netsparkerCloudProfileID");
        this.logScanParams(scanType, websiteId, profileId);
        VCSCommit vcsCommit = this.getVCSCommit(taskContext, customVariables);
        this.logScanInfoBeginning();
        this.logInfo("Requesting scan...");
        try {
            ScanRequest scanRequest = new ScanRequest(serverURL, apiToken, scanType, websiteId, profileId, vcsCommit);
            HttpResponse scanRequestResponse = scanRequest.scanRequest();
            this.logInfo("Response status code: " + scanRequestResponse.getStatusLine().getStatusCode());
            ScanRequestResult scanRequestResult = new ScanRequestResult(scanRequestResponse, serverURL, apiToken);
            if (scanRequestResult.getHttpStatusCode() == 201 && !scanRequestResult.isError()) {
                this.ScanRequestSuccessHandler(taskContext, builder, customVariables, scanRequestResult);
            } else {
                this.ScanRequestFailureHandler(builder, scanRequestResult);
            }
        }
        catch (Exception ex) {
            throw new TaskException(ex.getMessage());
        }
        this.logScanInfoEnd();
        TaskResult result = builder.build();
        return result;
    }

    private void ScanRequestSuccessHandler(TaskContext taskContext, TaskResultBuilder builder, Map<String, VariableDefinitionContext> customVariables, ScanRequestResult scanRequestResult) throws IOException {
        builder.success();
        BuildContext buildContext = taskContext.getBuildContext();
        String planKey = customVariables.get("planKey").getValue();
        String buildKey = customVariables.get("buildKey").getValue();
        String buildNumber = String.valueOf(buildContext.getBuildNumber());
        this.configManager.setScanTaskID(planKey, buildNumber, scanRequestResult.getScanTaskID());
        this.configManager.setScanTaskID(buildKey, buildNumber, scanRequestResult.getScanTaskID());
        this.logInfo("Scan requested successfully.");
    }

    private void ScanRequestFailureHandler(TaskResultBuilder builder, ScanRequestResult scanRequestResult) throws Exception {
        builder.failed();
        this.logError("Scan request failed. Error Message: " + scanRequestResult.getErrorMessage());
    }

    private VCSCommit getVCSCommit(TaskContext taskContext, Map<String, VariableDefinitionContext> customVariables) {
        VCSCommit vcsCommit;
        String pluginVersion;
        String bambooVersion;
        String buildURL;
        String buildConfigurationName;
        String buildId;
        boolean buildHasChange;
        List changes;
        block10: {
            BuildContext buildContext = taskContext.getBuildContext();
            AdministrationConfiguration administrationConfiguration = this.getAdministrationConfiguration();
            BuildChanges buildChanges = buildContext.getBuildChanges();
            changes = buildChanges.getChanges();
            buildHasChange = !changes.isEmpty();
            buildId = String.valueOf(buildContext.getBuildNumber());
            buildConfigurationName = buildContext.getPlanName();
            buildURL = administrationConfiguration.getBaseUrl() + "/browse/" + buildContext.getPlanResultKey().toString();
            bambooVersion = "";
            pluginVersion = "";
            try {
                Properties properties = new Properties();
                properties.load(this.getClass().getClassLoader().getResourceAsStream("ApplicationInfo.properties"));
                pluginVersion = properties.getProperty("PluginVersion");
                String productVersion = System.getProperty("product.version");
                if (productVersion != null) {
                    bambooVersion = productVersion;
                }
            }
            catch (Exception e) {
                if (AppCommon.IsNullOrEmpty(bambooVersion)) {
                    bambooVersion = "";
                }
                if (!AppCommon.IsNullOrEmpty(pluginVersion)) break block10;
                pluginVersion = "Not found.";
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
        String dateString = dateFormat.format(new Date());
        if (buildHasChange) {
            String vcsName;
            CommitContext commitContext = (CommitContext)changes.get(0);
            AuthorContext authorContext = commitContext.getAuthorContext();
            Date date = commitContext.getDate();
            dateString = dateFormat.format(date);
            String changeSetId = commitContext.getChangeSetId();
            if (AppCommon.IsNullOrEmpty(changeSetId)) {
                changeSetId = "Not Found.";
            }
            String userName = authorContext.getName();
            if (AppCommon.isValidEmailAddress(authorContext.getEmail())) {
                userName = authorContext.getEmail();
            }
            if (AppCommon.IsNullOrEmpty(userName)) {
                userName = "Not Found.";
            }
            if (AppCommon.IsNullOrEmpty(vcsName = customVariables.get("planRepository.type").getValue())) {
                userName = "Not Found.";
            }
            vcsCommit = new VCSCommit(bambooVersion, pluginVersion, buildId, buildConfigurationName, buildURL, buildHasChange, vcsName, userName, changeSetId, dateString);
        } else {
            vcsCommit = new VCSCommit(bambooVersion, pluginVersion, buildId, buildConfigurationName, buildURL, buildHasChange, "", "", "", dateString);
        }
        this.logBuildParams(vcsCommit);
        return vcsCommit;
    }

    private void logScanParams(String scanType, String websiteId, String profileId) {
        this.buildLogger.addBuildLogEntry("***************************************************************************\n");
        this.buildLogger.addBuildLogEntry("********************  Netsparker Enterprise Scan Parameters  *******************\n");
        this.buildLogger.addBuildLogEntry("***************************************************************************\n");
        this.logIfNotNull("Scan Type: " + scanType);
        this.logIfNotNull("Website Id: " + websiteId);
        this.logIfNotNull("Website Profile Id: " + profileId);
        this.buildLogger.addBuildLogEntry("***************************************************************************\n");
    }

    private void logBuildParams(VCSCommit commit) {
        this.buildLogger.addBuildLogEntry("********************  Netsparker Enterprise Build Parameters  ******************\n");
        this.buildLogger.addBuildLogEntry("***************************************************************************\n");
        this.logIfNotNull("Build Id: " + commit.getBuildId());
        this.logIfNotNull("Build configuration name: " + commit.getBuildConfigurationName());
        this.logIfNotNull("Build url: " + commit.getBuildURL());
        this.logIfNotNull("Build has change: " + commit.BuildHasChange());
        this.logIfNotNull("VCS Name: " + commit.getVersionControlName());
        this.logIfNotNull("Committer: " + commit.getCommitter());
        this.logIfNotNull("VCS Version: " + commit.getVcsVersion());
        this.logIfNotNull("Time stamp: " + commit.getCiTimestamp());
        this.logIfNotNull("Build server version: " + commit.getCiBuildServerVersion());
        this.logIfNotNull("PluginVersion: " + commit.getCiNcPluginVersion());
        this.logIfNotNull("***************************************************************************\n");
    }

    private void logScanInfoBeginning() {
        this.buildLogger.addBuildLogEntry("***********************  Netsparker Enterprise Scan Info  **********************\n");
        this.buildLogger.addBuildLogEntry("***************************************************************************\n");
    }

    private void logScanInfoEnd() {
        this.buildLogger.addBuildLogEntry("***************************************************************************\n");
    }

    private void logIfNotNull(String message) {
        if (!AppCommon.IsNullOrEmpty(message)) {
            this.buildLogger.addBuildLogEntry(message);
        }
    }

    private void logInfo(String message) {
        this.buildLogger.addBuildLogEntry("> Info: " + message);
    }

    private void logError(String message) {
        this.buildLogger.addErrorLogEntry("> Error: " + message);
    }
}

