/*
 * Decompiled with CFR 0.152.
 */
package com.netsparker.tasks;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.bamboo.build.PlanResultsAction;
import com.netsparker.model.ScanReport;
import com.netsparker.tasks.NetsparkerCloudScanHelper;
import org.apache.log4j.Logger;

@AnonymousSiteAccess
public class NetsparkerCloudReport
extends PlanResultsAction {
    String buildNumber;
    String scanTaskID;
    String hasError;
    String errorMessage;
    String isReportGenerated;
    private static final Logger log = Logger.getLogger(NetsparkerCloudReport.class);

    public String execute() throws Exception {
        String result = super.execute();
        try {
            String scanTaskID;
            NetsparkerCloudScanHelper netsparkerCloudScanHelper = new NetsparkerCloudScanHelper();
            this.scanTaskID = scanTaskID = netsparkerCloudScanHelper.GetScanTaskID(this.getBuildKey(), this.getBuildNumberString());
            ScanReport scanReport = netsparkerCloudScanHelper.GetScanReport(scanTaskID);
            this.isReportGenerated = String.valueOf(scanReport.isReportGenerated());
            this.hasError = "false";
            this.errorMessage = "";
        }
        catch (Exception ex) {
            this.hasError = "true";
            this.isReportGenerated = "false";
            this.errorMessage = ex.getMessage();
            log.debug((Object)ex.getMessage());
        }
        return result;
    }

    public String getScanTaskID() {
        return this.scanTaskID;
    }

    public String getHasError() {
        return this.hasError;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getIsReportGenerated() {
        return this.isReportGenerated;
    }

    public String getBuildNumberString() {
        return this.buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }
}

