/*
 * Decompiled with CFR 0.152.
 */
package com.netsparker.model;

import com.netsparker.model.ScanRequestBase;
import com.netsparker.model.WebsiteModel;
import com.netsparker.model.WebsiteProfileModel;
import com.netsparker.utility.AppCommon;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WebsiteModelRequest
extends ScanRequestBase {
    public static final String Websites_JSON_MODEL_Literal = "netsparkerCloudWebsitesJsonModel";
    private String websitesJsonModel = "";
    private ArrayList<WebsiteModel> websiteModels = new ArrayList();
    private HttpResponse response;
    private final URI pluginWebSiteModelsUri = new URL(this.ApiURL, "api/1.0/scans/PluginWebSiteModels").toURI();

    public WebsiteModelRequest(String apiURL, String apiToken) throws MalformedURLException, NullPointerException, URISyntaxException {
        super(apiURL, apiToken);
    }

    public ArrayList<WebsiteModel> getWebsiteModels() {
        return this.websiteModels;
    }

    public HttpResponse getPluginWebSiteModels() throws IOException, JSONException {
        HttpClient httpClient = this.getHttpClient();
        HttpGet httpGet = new HttpGet(this.pluginWebSiteModelsUri);
        httpGet.setHeader("Accept", "application/json");
        httpGet.setHeader("Authorization", this.getAuthHeader());
        this.response = httpClient.execute((HttpUriRequest)httpGet);
        if (this.response.getStatusLine().getStatusCode() == 200) {
            this.parseWebsiteData();
        }
        return this.response;
    }

    private void parseWebsiteData() throws IOException, JSONException {
        String data;
        this.websitesJsonModel = data = AppCommon.parseResponseToString(this.response);
        this.websiteModels = new ArrayList();
        JSONArray jsonObjectArr = new JSONArray(data.trim());
        for (int w = 0; w < jsonObjectArr.length(); ++w) {
            JSONObject websiteModelJson = jsonObjectArr.getJSONObject(w);
            WebsiteModel websiteModel = new WebsiteModel();
            websiteModel.setId((String)websiteModelJson.get("Id"));
            websiteModel.setName((String)websiteModelJson.get("Name"));
            websiteModel.setUrl((String)websiteModelJson.get("Url"));
            JSONArray websiteProfileModelJsonArr = (JSONArray)websiteModelJson.get("WebsiteProfiles");
            ArrayList<WebsiteProfileModel> profiles = new ArrayList<WebsiteProfileModel>();
            for (int i = 0; i < websiteProfileModelJsonArr.length(); ++i) {
                JSONObject websiteProfileModelJson = websiteProfileModelJsonArr.getJSONObject(i);
                WebsiteProfileModel websiteProfileModel = new WebsiteProfileModel();
                websiteProfileModel.setId((String)websiteProfileModelJson.get("Id"));
                websiteProfileModel.setName((String)websiteProfileModelJson.get("Name"));
                profiles.add(websiteProfileModel);
            }
            websiteModel.setProfiles(profiles);
            this.websiteModels.add(websiteModel);
        }
    }

    public String getWebsitesJsonModel() {
        try {
            this.getPluginWebSiteModels();
        }
        catch (Exception ex) {
            this.hasError = true;
            this.errorMessage = ex.getMessage();
        }
        return this.websitesJsonModel;
    }
}

