/*
 * Decompiled with CFR 0.152.
 */
package com.netsparker.model;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.netsparker.utility.AppCommon;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.io.IOException;
import org.apache.http.HttpResponse;

public class ScanReport {
    private final HttpResponse reportRequestResponse;
    private final boolean scanRequestHasError;
    private final String scanRequestErrorMessage;
    private final boolean reportRequestHasError;
    private final String reportRequestErrorMessage;
    private final String requestURI;
    private static String reportHtmlAsString = null;

    public ScanReport(HttpResponse reportRequestResponse, String requestURI) {
        this.reportRequestResponse = reportRequestResponse;
        this.scanRequestHasError = false;
        this.scanRequestErrorMessage = "";
        this.reportRequestHasError = false;
        this.reportRequestErrorMessage = "";
        this.requestURI = requestURI;
    }

    public ScanReport(boolean scanRequestHasError, String scanRequestErrorMessage, boolean reportRequestHasError, String reportRequestErrorMessage, String requestURI) {
        this.reportRequestResponse = null;
        this.scanRequestHasError = scanRequestHasError;
        this.scanRequestErrorMessage = scanRequestErrorMessage;
        this.reportRequestHasError = reportRequestHasError;
        this.reportRequestErrorMessage = reportRequestErrorMessage;
        this.requestURI = requestURI;
    }

    private String getContentType() {
        return this.reportRequestResponse.getHeaders("Content-Type")[0].getValue();
    }

    public boolean isReportGenerated() {
        try {
            return this.getContentType().equalsIgnoreCase("text/html");
        }
        catch (Exception ex) {
            return false;
        }
    }

    public String getContent() {
        String content;
        block9: {
            content = "";
            try {
                if (this.scanRequestHasError) {
                    content = this.ExceptionContent(content, this.scanRequestErrorMessage);
                    break block9;
                }
                if (this.reportRequestHasError) {
                    content = this.ExceptionContent(content, this.reportRequestErrorMessage);
                    break block9;
                }
                String contentData = null;
                try {
                    reportHtmlAsString = contentData = AppCommon.parseResponseToString(this.reportRequestResponse);
                }
                catch (IOException ex) {
                    contentData = reportHtmlAsString;
                }
                if (this.isReportGenerated()) {
                    content = contentData;
                } else {
                    JSONObject data = (JSONObject)new Gson().fromJson(contentData, JSONObject.class);
                    content = data.getString("Message");
                }
            }
            catch (JsonParseException ex) {
                content = this.ExceptionContent("Report result is not parsable.", ex.toString());
            }
            catch (Exception ex) {
                content = this.ExceptionContent(content, ex.toString());
            }
        }
        return content;
    }

    private String ExceptionContent(String content, String ExceptionMessage) {
        content = content != null && !((String)content).isEmpty() ? "<p>" + (String)content + "</p>" : "<p>Something went wrong.</p>";
        if (this.requestURI != null) {
            content = (String)content + "<p>Request URL: " + this.requestURI + "</p>";
        }
        if (this.reportRequestResponse != null && this.reportRequestResponse.getStatusLine() != null) {
            content = (String)content + "<p>HttpStatusCode: " + this.reportRequestResponse.getStatusLine().getStatusCode() + "</p>";
        }
        if (ExceptionMessage != null) {
            content = (String)content + "<p>Exception Message:: " + ExceptionMessage + "</p>";
        }
        return content;
    }
}

