/*
 * Decompiled with CFR 0.152.
 */
package com.netsparker;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.AdministrationConfigurationPersister;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.netsparker.utility.AppCommon;
import javax.inject.Inject;

public class PluginSettings
extends BambooActionSupport
implements GlobalAdminSecurityAware {
    private String apiUrl;
    private String apiToken;
    private String hideWebsiteList;
    @ComponentImport
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    @ComponentImport
    private final AdministrationConfigurationPersister administrationConfigurationPersister;
    @ComponentImport
    private final BandanaManager bandanaManager;

    @Inject
    public PluginSettings(AdministrationConfigurationAccessor administrationConfigurationAccessor, AdministrationConfigurationPersister administrationConfigurationPersister, BandanaManager bandanaManager) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.administrationConfigurationPersister = administrationConfigurationPersister;
        this.bandanaManager = bandanaManager;
        this.setAdministrationConfigurationAccessor(administrationConfigurationAccessor);
        this.setAdministrationConfigurationPersister(administrationConfigurationPersister);
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getApiToken() {
        return this.apiToken;
    }

    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }

    public String getHideWebsiteList() {
        return this.hideWebsiteList;
    }

    public void setHideWebsiteList(String hideWebsiteList) {
        this.hideWebsiteList = hideWebsiteList;
    }

    public String doEdit() {
        this.setApiUrl(this.getValue("netsparkerCloudServerURL"));
        this.setApiToken(this.getValue("netsparkerCloudApiToken"));
        this.setHideWebsiteList(this.getValue("netsparkerCloudHideWebsiteList"));
        return "input";
    }

    public String doSave() {
        boolean hasError = false;
        if (!AppCommon.IsUrlValid(this.getApiUrl())) {
            hasError = true;
            this.addActionError("Please enter valid URL.");
        }
        if (AppCommon.IsNullOrEmpty(this.getApiToken())) {
            hasError = true;
            this.addActionError("API Token can't be empty.");
        }
        if (hasError) {
            return "error";
        }
        this.setValue("netsparkerCloudServerURL", this.getApiUrl());
        this.setValue("netsparkerCloudApiToken", this.getApiToken());
        this.setValue("netsparkerCloudHideWebsiteList", this.getHideWebsiteList());
        this.addActionMessage("Global settings updated.");
        return "success";
    }

    private String getValue(String key) {
        Object value = this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.netsparker:" + key);
        return (String)value;
    }

    private void setValue(String key, String value) {
        this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.netsparker:" + key, (Object)value);
    }
}

