/*
 * Decompiled with CFR 0.152.
 */
package com.netsparker;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.spring.container.ContainerManager;
import com.netsparker.utility.AppCommon;

public class ConfigManager {
    private BandanaManager bandanaManager = (BandanaManager)ContainerManager.getComponent((String)"bandanaManager");
    private ErrorCollection errorCollection;
    private final String pluginKey = "com.netsparker:";
    private final String scanTaskKey = "ScanTaskID";

    public ConfigManager() {
        this.bandanaManager.init();
    }

    public boolean hasCredentials() {
        return AppCommon.IsUrlValid(this.get("netsparkerCloudServerURL")) && AppCommon.IsNullOrEmpty(this.get("netsparkerCloudApiToken"));
    }

    public String getApiUrl() {
        return this.get("netsparkerCloudServerURL");
    }

    public String getApiToken() {
        return this.get("netsparkerCloudApiToken");
    }

    public String getHideWebsiteList() {
        return this.get("netsparkerCloudHideWebsiteList");
    }

    public String getScanTaskID(String planKey, String buildNumber) {
        String buildSpecificKey = planKey + "-" + buildNumber;
        return this.getBuildParameter(buildSpecificKey, "ScanTaskID");
    }

    public void setScanTaskID(String planKey, String buildNumber, String scanTaskID) {
        String buildSpecificKey = planKey + "-" + buildNumber;
        this.setBuildParameter(buildSpecificKey, "ScanTaskID", scanTaskID);
    }

    public ErrorCollection getErrorCollection() {
        return this.errorCollection;
    }

    public void setErrorCollection(ErrorCollection errorCollection) {
        this.errorCollection = errorCollection;
    }

    private String get(String key) {
        return (String)this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.netsparker:" + key);
    }

    private void setBuildParameter(String buildSpecificKey, String key, String value) {
        String pluginSpecificBuildKey = "com.netsparker::" + buildSpecificKey;
        String parameterKey = pluginSpecificBuildKey + ":" + key;
        this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, parameterKey, (Object)value);
    }

    private String getBuildParameter(String buildSpecificKey, String key) {
        String pluginSpecificBuildKey = "com.netsparker::" + buildSpecificKey;
        String parameterKey = pluginSpecificBuildKey + ":" + key;
        Object value = this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, parameterKey);
        return (String)value;
    }
}

