/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.validator;

import com.moveworkforward.validator.ValidatorBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeValidator<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompositeValidator.class);
    private List<ValidatorBuilder> allValidators = new ArrayList<ValidatorBuilder>();
    private List<ValidatorBuilder> failedValidators = new ArrayList<ValidatorBuilder>();
    private List<ValidatorBuilder> passedValidators = new ArrayList<ValidatorBuilder>();

    public ValidatorBuilder<T> getValidatorBuilder(T source) {
        ValidatorBuilder<T> validatorBuilder = this.createValidatorBuilder(source);
        this.allValidators.add(validatorBuilder);
        return validatorBuilder;
    }

    protected ValidatorBuilder<T> createValidatorBuilder(T source) {
        return new ValidatorBuilder<T>(source);
    }

    protected boolean validate() {
        this.failedValidators.clear();
        this.passedValidators.clear();
        this.allValidators.forEach(validatorBuilder -> {
            if (validatorBuilder.validate()) {
                this.passedValidators.add((ValidatorBuilder)validatorBuilder);
            } else {
                this.failedValidators.add((ValidatorBuilder)validatorBuilder);
            }
        });
        this.passedValidators.forEach(validatorBuilder -> log.info("Succeeded validation: " + String.valueOf(validatorBuilder)));
        this.failedValidators.forEach(validatorBuilder -> log.info("Failed validation: " + String.valueOf(validatorBuilder)));
        return !this.passedValidators.isEmpty();
    }

    public boolean any() {
        this.validate();
        return !this.passedValidators.isEmpty();
    }

    public boolean all() {
        this.validate();
        return this.failedValidators.isEmpty();
    }

    public List<T> getPassed() {
        this.validate();
        return this.passedValidators.stream().map(ValidatorBuilder::getSource).collect(Collectors.toList());
    }

    public List<T> getFailed() {
        this.validate();
        return this.failedValidators.stream().map(ValidatorBuilder::getSource).collect(Collectors.toList());
    }
}

