/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.service.impl;

import com.moveworkforward.ao.PluginSettingRepository;
import com.moveworkforward.exception.DetailedException;
import com.moveworkforward.model.AbstractGlobalSettings;
import com.moveworkforward.model.AbstractPluginEntity;
import com.moveworkforward.service.GlobalSettingsService;
import com.moveworkforward.service.OperationListener;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGlobalSettingsService<T extends AbstractGlobalSettings>
implements GlobalSettingsService<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractGlobalSettingsService.class);
    protected final PluginSettingRepository<T> repository;
    private final List<OperationListener> operationListeners;

    public AbstractGlobalSettingsService(PluginSettingRepository<T> repository, List<OperationListener> operationListeners) {
        this.repository = repository;
        this.operationListeners = operationListeners;
    }

    @Override
    public T get(boolean checkPermissions) {
        if (checkPermissions) {
            this.hasUserAdminPermissions();
        }
        return (T)((AbstractGlobalSettings)this.repository.getAll().stream().findFirst().orElse(this.getDefaultSettings()));
    }

    @Override
    public T delete(boolean checkPermissions) {
        AbstractGlobalSettings settings;
        if (checkPermissions) {
            this.hasUserAdminPermissions();
        }
        if ((settings = (AbstractGlobalSettings)this.repository.getAll().stream().findFirst().orElse(null)) == null) {
            log.info("Nothing to remove, global settings has not been saved yet");
            return null;
        }
        AbstractGlobalSettings result = (AbstractGlobalSettings)this.repository.delete(settings.getId());
        this.callOperationListeners(result, OperationListener.OperationType.DELETE);
        return (T)result;
    }

    protected abstract String getUser();

    @Override
    public T save(T entity, boolean checkPermissions) {
        if (checkPermissions) {
            this.hasUserAdminPermissions();
        }
        this.validate(entity);
        AbstractGlobalSettings existingEntity = this.repository.getAll().stream().findFirst().orElse(null);
        OperationListener.OperationType operationType = OperationListener.OperationType.CREATE;
        if (existingEntity != null) {
            operationType = OperationListener.OperationType.UPDATE;
            this.merge(existingEntity, entity);
        }
        AbstractGlobalSettings result = (AbstractGlobalSettings)this.repository.save(entity);
        this.callOperationListeners(result, operationType);
        return (T)result;
    }

    protected void merge(T existingEntity, T newEntity) {
        ((AbstractPluginEntity)newEntity).setId(((AbstractPluginEntity)existingEntity).getId());
    }

    protected abstract void hasUserAdminPermissions();

    protected abstract T getDefaultSettings();

    protected void validate(T entity) {
        if (((AbstractGlobalSettings)entity).isAppEnabledInEntitites() && ((AbstractGlobalSettings)entity).isAppDisabledInEntities() && CollectionUtils.containsAny(((AbstractGlobalSettings)entity).getAllowedKeys(), ((AbstractGlobalSettings)entity).getIgnoredKeys())) {
            throw new DetailedException("The same key can not be used in allowed and ignored keys", "appEnabledInEntitites", "appDisabledInEntities");
        }
    }

    protected void callOperationListeners(T result, OperationListener.OperationType operationType) {
        if (CollectionUtils.isNotEmpty(this.operationListeners)) {
            this.operationListeners.forEach(listener -> {
                try {
                    listener.onOperationPerformed(result, operationType);
                }
                catch (Exception e) {
                    log.error("Error during operation {} listener call", listener.getClass(), (Object)e);
                }
            });
        }
    }
}

