/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.rest;

import com.moveworkforward.component.UserSurveyManager;
import com.moveworkforward.model.SurveySettings;
import com.moveworkforward.model.User;
import com.moveworkforward.model.UserSurvey;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public abstract class AbstractUserSurveyController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractUserSurveyController.class);
    protected final UserSurveyManager surveyManager;
    protected final Environment environment;

    public AbstractUserSurveyController(UserSurveyManager surveyManager, Environment environment) {
        this.surveyManager = surveyManager;
        this.environment = environment;
    }

    @GET
    @Path(value="/{surveyId}")
    public List<UserSurvey> getSurveys(@PathParam(value="surveyId") String surveyId, @QueryParam(value="userKey") String userKey) {
        User user = this.getCurrentUser();
        if (userKey != null && (user.getUserKey().equals(userKey) || this.isAdmin(user))) {
            UserSurvey survey = this.surveyManager.getSurvey(userKey, surveyId);
            if (survey == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(survey);
        }
        if (this.isAdmin(user)) {
            return this.surveyManager.getSurveys(surveyId);
        }
        return Collections.emptyList();
    }

    protected abstract boolean isAdmin(User var1);

    @POST
    @Path(value="/submit/{surveyId}")
    public UserSurvey submitSurvey(@PathParam(value="surveyId") String surveyId) {
        User user = this.getCurrentUser();
        return this.surveyManager.submitSurvey(user.getUserKey(), surveyId);
    }

    @POST
    @Path(value="/close/{surveyId}")
    public UserSurvey closeSurvey(@PathParam(value="surveyId") String surveyId) {
        User user = this.getCurrentUser();
        return this.surveyManager.cancelSurvey(user.getUserKey(), surveyId);
    }

    @POST
    @Path(value="/reset/{surveyId}")
    public void resetSurvey(@PathParam(value="surveyId") String surveyId) {
        if (!this.isAdmin(this.getCurrentUser())) {
            throw new RuntimeException("This operation is not allowed");
        }
        this.surveyManager.resetSurvey(surveyId);
    }

    @DELETE
    @Path(value="/settings/reset")
    public SurveySettings resetSettings() {
        if (!this.isAdmin(this.getCurrentUser())) {
            throw new RuntimeException("This operation is not allowed");
        }
        return this.surveyManager.resetSettings();
    }

    @GET
    @Path(value="/settings")
    public SurveySettings getSettings() {
        if (!this.isAdmin(this.getCurrentUser())) {
            throw new RuntimeException("This operation is not allowed");
        }
        return this.surveyManager.getSurveySettings();
    }

    @POST
    @Path(value="/settings")
    public SurveySettings saveSettings(SurveySettings settings) {
        if (!this.isAdmin(this.getCurrentUser())) {
            throw new RuntimeException("This operation is not allowed");
        }
        SurveySettings existingSettings = this.surveyManager.getSurveySettings();
        if (settings.getSubmissionPeriod() > 0L) {
            existingSettings.setSubmissionPeriod(settings.getSubmissionPeriod());
        }
        if (settings.getLicenseCancellationPeriod() > 0L) {
            existingSettings.setLicenseCancellationPeriod(settings.getLicenseCancellationPeriod());
        }
        if (settings.getEvaluationCancellationPeriod() > 0L) {
            existingSettings.setEvaluationCancellationPeriod(settings.getEvaluationCancellationPeriod());
        }
        existingSettings.setEnabled(settings.isEnabled());
        return this.surveyManager.saveSurveySettings(existingSettings);
    }

    protected abstract User getCurrentUser();
}

