/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.rest;

import com.moveworkforward.model.ConfigurationAudit;
import com.moveworkforward.service.ConfigurationAuditService;
import com.moveworkforward.util.ConnectorUtil;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.BufferedOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public abstract class AbstractConfigurationAuditController {
    private final ConfigurationAuditService configurationAuditService;

    public AbstractConfigurationAuditController(ConfigurationAuditService configurationAuditService) {
        this.configurationAuditService = configurationAuditService;
    }

    @GET
    public List<ConfigurationAudit> getAll(@QueryParam(value="entityType") String entityType, @QueryParam(value="operationType") String operationType) {
        return this.configurationAuditService.getByEntityAndOperation(entityType, operationType);
    }

    @Path(value="/download")
    @GET
    @Produces(value={"application/octet-stream"})
    public Response download() {
        List<ConfigurationAudit> data = this.configurationAuditService.getAll();
        String content = ConnectorUtil.createObjectMapper().writeValueAsString(data);
        StreamingOutput streamingOutput = outputStream -> {
            ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(outputStream));
            zipOut.putNextEntry(new ZipEntry("content.json"));
            zipOut.write(content.getBytes(StandardCharsets.UTF_8));
            zipOut.closeEntry();
            zipOut.close();
            outputStream.flush();
            outputStream.close();
        };
        return Response.ok((Object)streamingOutput).header("Content-Disposition", (Object)"attachment; filename=\"message-audit.zip\"").build();
    }

    @DELETE
    public int deleteAll() {
        return this.configurationAuditService.deleteAll();
    }

    @DELETE
    @Path(value="/{entityType}")
    public int deleteByEntityType(@PathParam(value="entityType") String entityType) {
        return this.configurationAuditService.deleteByEntityType(entityType).size();
    }
}

