/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.report;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.moveworkforward.report.ScheduledReportJobRunner;
import com.moveworkforward.service.CallBackReportService;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScheduledReportManager
implements CallBackReportService.OperationCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractScheduledReportManager.class);
    private final SchedulerService schedulerService;
    private final ScheduledReportJobRunner scheduledReportJobRunner;
    private final List<CallBackReportService> callBackReportServices;
    private boolean started;

    public AbstractScheduledReportManager(SchedulerService schedulerService, ScheduledReportJobRunner scheduledReportJobRunner, List<CallBackReportService> callBackReportServices) {
        this.schedulerService = schedulerService;
        this.scheduledReportJobRunner = scheduledReportJobRunner;
        this.callBackReportServices = callBackReportServices;
    }

    protected abstract JobId getJobId();

    protected abstract JobRunnerKey getJobRunnerKey();

    protected String getCronExpression() {
        return "0 0/15 * ? * * *";
    }

    protected void init() {
        Executors.newScheduledThreadPool(1).schedule(() -> this.callBackReportServices.forEach(callBackReportService -> callBackReportService.addCallBack(this)), 5L, TimeUnit.SECONDS);
    }

    public void unscheduleJob() {
        try {
            this.schedulerService.unscheduleJob(this.getJobId());
            log.info("Report job unscheduled, {}", (Object)this.getJobId());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean scheduleJob() {
        try {
            this.schedulerService.scheduleJob(this.getJobId(), JobConfig.forJobRunnerKey((JobRunnerKey)this.getJobRunnerKey()).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forCronExpression((String)this.getCronExpression())));
            log.info("Report job scheduled, expression '{}'", (Object)this.getCronExpression());
            return true;
        }
        catch (SchedulerServiceException e) {
            log.error("Report runner " + String.valueOf(this.getJobRunnerKey()) + " is not started", (Throwable)e);
            return false;
        }
    }

    public void unregisterJobRunner() {
        try {
            this.schedulerService.unregisterJobRunner(this.getJobRunnerKey());
            log.info("Report job runner {} unregistered", (Object)this.getJobRunnerKey());
        }
        catch (Exception e) {
            log.error("Can't unregister report job runner " + String.valueOf(this.getJobRunnerKey()), (Throwable)e);
        }
    }

    public boolean registerJobRunner() {
        try {
            this.schedulerService.registerJobRunner(this.getJobRunnerKey(), (JobRunner)this.scheduledReportJobRunner);
            log.info("Report job runner {} registered", (Object)this.getJobRunnerKey());
            return true;
        }
        catch (Exception e) {
            log.error("Can't register report job runner " + String.valueOf(this.getJobRunnerKey()), (Throwable)e);
            return false;
        }
    }

    public synchronized void startIfNeeded() {
        if (this.started) {
            log.debug("Job has already been started");
            return;
        }
        boolean bl = this.started = this.registerJobRunner() && this.scheduleJob();
        if (!this.started) {
            log.warn("Unschedule reports for {}", (Object)this.getJobRunnerKey());
            this.unscheduleJob();
            this.unregisterJobRunner();
        }
    }

    @Override
    public void onSave(Object configuration) {
        this.startIfNeeded();
    }

    @Override
    public void onCount(int count) {
        if (count > 0) {
            this.startIfNeeded();
        }
    }
}

