/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.moveworkforward.exception.DetailedException;
import com.moveworkforward.model.User;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
public class UrlManagement {
    private boolean enabled = true;
    private List<String> excludedSources = new ArrayList<String>();
    private List<User> excludedUsers = new ArrayList<User>();
    private boolean onlyManagedUrls = false;
    private String urlPattern;

    public void validateUrl(String url) {
        if (url == null) {
            throw new DetailedException("Invalid webhook url (null)", "destinations.url");
        }
        if (url.trim().equals("")) {
            throw new DetailedException("Invalid webhook url (empty)", "destinations.url");
        }
        if (StringUtils.isNotBlank((CharSequence)this.urlPattern) && !url.matches(this.urlPattern)) {
            throw new DetailedException("Invalid url, url should match pattern: " + this.urlPattern, "destinations.url");
        }
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public List<String> getExcludedSources() {
        return this.excludedSources;
    }

    @Generated
    public List<User> getExcludedUsers() {
        return this.excludedUsers;
    }

    @Generated
    public boolean isOnlyManagedUrls() {
        return this.onlyManagedUrls;
    }

    @Generated
    public String getUrlPattern() {
        return this.urlPattern;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setExcludedSources(List<String> excludedSources) {
        this.excludedSources = excludedSources;
    }

    @Generated
    public void setExcludedUsers(List<User> excludedUsers) {
        this.excludedUsers = excludedUsers;
    }

    @Generated
    public void setOnlyManagedUrls(boolean onlyManagedUrls) {
        this.onlyManagedUrls = onlyManagedUrls;
    }

    @Generated
    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    @Generated
    public String toString() {
        return "UrlManagement(enabled=" + this.enabled + ", excludedSources=" + String.valueOf(this.excludedSources) + ", excludedUsers=" + String.valueOf(this.excludedUsers) + ", onlyManagedUrls=" + this.onlyManagedUrls + ", urlPattern=" + this.urlPattern + ")";
    }
}

