/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.util.JsonDateSerializer;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
public class MessageAudit
implements PluginEntity {
    private Integer id;
    @JsonSerialize(using=JsonDateSerializer.class)
    @JsonProperty(value="createdAt")
    private Date lastModified;
    private String tag;
    private String eventType;
    private Map<String, Serializable> targetDetails = new LinkedHashMap<String, Serializable>();
    private Configuration configuration;
    private String error;

    @Override
    public String getKey() {
        return String.valueOf(this.id);
    }

    public void setException(Exception e) {
        String error = Stream.of(e.getStackTrace()).limit(10L).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
        this.setError(error);
    }

    @Generated
    public static MessageAuditBuilder builder() {
        return new MessageAuditBuilder();
    }

    @Generated
    public MessageAuditBuilder toBuilder() {
        return new MessageAuditBuilder().id(this.id).lastModified(this.lastModified).tag(this.tag).eventType(this.eventType).targetDetails(this.targetDetails).configuration(this.configuration).error(this.error);
    }

    @Override
    @Generated
    public Integer getId() {
        return this.id;
    }

    @Override
    @Generated
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    @Generated
    public String getTag() {
        return this.tag;
    }

    @Generated
    public String getEventType() {
        return this.eventType;
    }

    @Generated
    public Map<String, Serializable> getTargetDetails() {
        return this.targetDetails;
    }

    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Override
    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    @JsonProperty(value="createdAt")
    @Generated
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    @Generated
    public void setTag(String tag) {
        this.tag = tag;
    }

    @Generated
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Generated
    public void setTargetDetails(Map<String, Serializable> targetDetails) {
        this.targetDetails = targetDetails;
    }

    @Generated
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Generated
    public void setError(String error) {
        this.error = error;
    }

    @Generated
    public String toString() {
        return "MessageAudit(id=" + this.getId() + ", lastModified=" + String.valueOf(this.getLastModified()) + ", tag=" + this.getTag() + ", eventType=" + this.getEventType() + ", targetDetails=" + String.valueOf(this.getTargetDetails()) + ", configuration=" + String.valueOf(this.getConfiguration()) + ", error=" + this.getError() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageAudit)) {
            return false;
        }
        MessageAudit other = (MessageAudit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.id;
        Integer other$id = other.id;
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MessageAudit;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.id;
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public MessageAudit(Integer id, Date lastModified, String tag, String eventType, Map<String, Serializable> targetDetails, Configuration configuration, String error) {
        this.id = id;
        this.lastModified = lastModified;
        this.tag = tag;
        this.eventType = eventType;
        this.targetDetails = targetDetails;
        this.configuration = configuration;
        this.error = error;
    }

    @Generated
    public MessageAudit() {
    }

    @Generated
    public static class MessageAuditBuilder {
        @Generated
        private Integer id;
        @Generated
        private Date lastModified;
        @Generated
        private String tag;
        @Generated
        private String eventType;
        @Generated
        private Map<String, Serializable> targetDetails;
        @Generated
        private Configuration configuration;
        @Generated
        private String error;

        @Generated
        MessageAuditBuilder() {
        }

        @Generated
        public MessageAuditBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="createdAt")
        @Generated
        public MessageAuditBuilder lastModified(Date lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @Generated
        public MessageAuditBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        @Generated
        public MessageAuditBuilder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Generated
        public MessageAuditBuilder targetDetails(Map<String, Serializable> targetDetails) {
            this.targetDetails = targetDetails;
            return this;
        }

        @Generated
        public MessageAuditBuilder configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public MessageAuditBuilder error(String error) {
            this.error = error;
            return this;
        }

        @Generated
        public MessageAudit build() {
            return new MessageAudit(this.id, this.lastModified, this.tag, this.eventType, this.targetDetails, this.configuration, this.error);
        }

        @Generated
        public String toString() {
            return "MessageAudit.MessageAuditBuilder(id=" + this.id + ", lastModified=" + String.valueOf(this.lastModified) + ", tag=" + this.tag + ", eventType=" + this.eventType + ", targetDetails=" + String.valueOf(this.targetDetails) + ", configuration=" + String.valueOf(this.configuration) + ", error=" + this.error + ")";
        }
    }

    @JsonAutoDetect
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Configuration {
        private Integer id;
        private String name;
        private String url;

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Configuration)) {
                return false;
            }
            Configuration other = (Configuration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$id = this.getId();
            Integer other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Configuration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Integer getId() {
            return this.id;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setId(Integer id) {
            this.id = id;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public String toString() {
            return "MessageAudit.Configuration(id=" + this.getId() + ", name=" + this.getName() + ", url=" + this.getUrl() + ")";
        }

        @Generated
        public Configuration(Integer id, String name, String url) {
            this.id = id;
            this.name = name;
            this.url = url;
        }

        @Generated
        public Configuration() {
        }
    }
}

