/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.moveworkforward.ao.entity.EntityType;
import com.moveworkforward.model.AbstractPluginEntity;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
@EntityType(value="VERSION_CONTENT")
public class AppVersion
extends AbstractPluginEntity
implements Comparable<AppVersion> {
    public static final String TYPE = "VERSION_CONTENT";
    private String key;
    private String name;
    private String version;
    private String notes;
    private String url;

    public AppVersion(String key) {
        this.key = key;
    }

    public AppVersion(String key, String name, String version) {
        this(key, name, version, null, null);
    }

    public AppVersion(String key, String name, String version, String notes) {
        this(key, name, version, notes, null);
    }

    @Override
    public int compareTo(AppVersion that) {
        return new MinorVersionComparator().compare(this, that);
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return Objects.equals(this.getKey(), ((AppVersion)that).getKey()) && this.compareTo((AppVersion)that) == 0;
    }

    private static Integer parseNumber(String value) {
        if (StringUtils.isNumeric((CharSequence)value)) {
            return Integer.parseInt(value);
        }
        char c = value.charAt(0);
        if (c >= '0' && c <= '9') {
            return Integer.parseInt("" + c);
        }
        return 0;
    }

    @Generated
    public AppVersion(String key, String name, String version, String notes, String url) {
        this.key = key;
        this.name = name;
        this.version = version;
        this.notes = notes;
        this.url = url;
    }

    @Generated
    public AppVersion() {
    }

    @Override
    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getNotes() {
        return this.notes;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    @Generated
    public String toString() {
        return "AppVersion(super=" + super.toString() + ", key=" + this.key + ", name=" + this.name + ", version=" + this.version + ", notes=" + this.notes + ", url=" + this.url + ")";
    }

    public static class MinorVersionComparator
    extends AbstractVersionComparator {
        public MinorVersionComparator() {
            super(false);
        }
    }

    private static abstract class AbstractVersionComparator
    implements Comparator<AppVersion> {
        private final boolean onlyMajor;

        protected AbstractVersionComparator(boolean onlyMajor) {
            this.onlyMajor = onlyMajor;
        }

        @Override
        public int compare(AppVersion o1, AppVersion o2) {
            String version1 = Optional.ofNullable(o1).map(AppVersion::getVersion).orElse(null);
            String version2 = Optional.ofNullable(o2).map(AppVersion::getVersion).orElse(null);
            if (StringUtils.isBlank((CharSequence)version1) && StringUtils.isBlank((CharSequence)version2)) {
                return 0;
            }
            if (StringUtils.isNotBlank((CharSequence)version1) && StringUtils.isBlank((CharSequence)version2)) {
                return 1;
            }
            if (StringUtils.isNotBlank((CharSequence)version2) && StringUtils.isBlank((CharSequence)version1)) {
                return -1;
            }
            String[] thisParts = version1.split("\\.");
            String[] thatParts = version2.split("\\.");
            int length = Math.max(thisParts.length, thatParts.length);
            length = this.onlyMajor ? 1 : length;
            for (int i = 0; i < length; ++i) {
                int thatPart;
                int thisPart = i < thisParts.length ? AppVersion.parseNumber(thisParts[i]) : 0;
                int n = thatPart = i < thatParts.length ? AppVersion.parseNumber(thatParts[i]) : 0;
                if (thisPart < thatPart) {
                    return -1;
                }
                if (thisPart <= thatPart) continue;
                return 1;
            }
            return 0;
        }
    }

    public static class MajorVersionComparator
    extends AbstractVersionComparator {
        public MajorVersionComparator() {
            super(true);
        }
    }
}

