/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.bamboo.microsoftteams.notifier;

import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.moveworkforward.bamboo.microsoftteams.notifier.BeansProvider;
import com.moveworkforward.bamboo.microsoftteams.notifier.LicenseManager;
import com.moveworkforward.util.MwfPropertyUtils;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.apache.log4j.Logger;
import org.springframework.core.env.Environment;

@Named(value="MicrosoftTeamsLicenseManager")
public class LicenseManagerImpl
implements LicenseManager {
    private static final Logger log = Logger.getLogger(LicenseManagerImpl.class);
    private boolean isDevMode;
    private BeansProvider beansProvider;

    @Inject
    public LicenseManagerImpl(Environment environment, BeansProvider beansProvider) {
        this.isDevMode = MwfPropertyUtils.getInstance().isDevMode(environment);
        this.beansProvider = beansProvider;
    }

    @Override
    public boolean isLicensed() {
        boolean result = true;
        if (this.isDevMode) {
            log.info((Object)"Microsoft Teams Bamboo Connector: License check is skipped");
        } else if (this.beansProvider.getPluginLicenseManager() != null) {
            try {
                Option license = ((PluginLicenseManager)this.beansProvider.getPluginLicenseManager()).getLicense();
                result = license.isDefined() && ((PluginLicense)license.get()).isValid();
            }
            catch (Exception e) {
                log.error((Object)"No Licence can be gotten");
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            log.info((Object)"PluginLicenseManager is not defined");
        }
        if (result) {
            log.info((Object)"Microsoft Teams Bamboo Connector: Plugin licensed.");
        } else {
            log.error((Object)"Microsoft Teams Bamboo Connector: There is no valid licence");
        }
        return result;
    }
}

