/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.ao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.moveworkforward.ao.ScheduledPluginRepository;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.ao.entity.ReportEntity;
import com.moveworkforward.ao.entity.ScheduledEntity;
import com.moveworkforward.ao.impl.AbstractPluginRepository;
import com.moveworkforward.util.DayTimeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScheduledConfigurationRepository<T extends ScheduledEntity & PluginEntity>
extends AbstractPluginRepository<T, ReportEntity>
implements ScheduledPluginRepository<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractScheduledConfigurationRepository.class);
    protected TransactionTemplate transactionTemplate;

    public AbstractScheduledConfigurationRepository(ActiveObjects activeObjects, TransactionTemplate transactionTemplate) {
        super(activeObjects, ReportEntity.class, transactionTemplate);
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public T get(int id) {
        return (T)((ScheduledEntity)this.transactionTemplate.execute(() -> (ScheduledEntity)super.get(id)));
    }

    @Override
    public List<T> getAll() {
        return (List)this.transactionTemplate.execute(() -> super.getAll());
    }

    @Override
    public List<T> getByDateAndTime(Date date, int hour, int minute) {
        return (List)this.transactionTemplate.execute(() -> {
            log.debug("Get entities by date:{}, hour: {}, minute: {} , type: {}", new Object[]{date, hour, minute, this.entityType});
            String dateTimePattern = DayTimeUtil.getDateTimePattern(date, hour, minute);
            List<ReportEntity> entities = Arrays.asList((ReportEntity[])this.activeObjects.find(ReportEntity.class, Query.select().where("TYPE = ? AND ENABLED = ? AND REPORT_TIME like ?", new Object[]{this.entityType, true, dateTimePattern})));
            if (entities.isEmpty()) {
                log.debug("Entities with time {} is not found", (Object)dateTimePattern);
                return new ArrayList();
            }
            return entities.stream().map(this::convertValue).collect(Collectors.toList());
        });
    }

    @Override
    public List<T> getByDateAndTime(int day, int hour, int minute) {
        return (List)this.transactionTemplate.execute(() -> {
            log.debug("Get entities by day:{}, hour: {}, minute: {} , type: {}", new Object[]{day, hour, minute, this.entityType});
            String dateTimePattern = DayTimeUtil.getDateTimePattern(day, hour, minute);
            List<ReportEntity> entities = Arrays.asList((ReportEntity[])this.activeObjects.find(ReportEntity.class, Query.select().where("TYPE = ? AND ENABLED = ? AND REPORT_TIME like ?", new Object[]{this.entityType, true, dateTimePattern})));
            if (entities.isEmpty()) {
                log.debug("Entities with time {} is not found", (Object)dateTimePattern);
                return new ArrayList();
            }
            return entities.stream().map(this::convertValue).collect(Collectors.toList());
        });
    }

    @Override
    protected void updateParams(ReportEntity reportEntity, T entity) throws IOException {
        reportEntity.setKey(((PluginEntity)entity).getKey());
        reportEntity.setTag(((PluginEntity)entity).getTag());
        reportEntity.setReportTime(entity.getReportTime());
        reportEntity.setEnabled(entity.isEnabled());
        reportEntity.setContent(this.objectMapper.writeValueAsString(entity));
    }

    @Override
    protected Map<String, Object> createParams(T entity) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("TYPE", this.entityType);
        params.put("KEY", ((PluginEntity)entity).getKey());
        params.put("TAG", ((PluginEntity)entity).getTag());
        params.put("REPORT_TIME", entity.getReportTime());
        params.put("ENABLED", entity.isEnabled());
        params.put("CONTENT", this.objectMapper.writeValueAsString(entity));
        return params;
    }

    @Override
    public List<T> getByTag(String tag) {
        log.debug("Get entities by tag: {} , type: {}", (Object)tag, (Object)this.entityType);
        return (List)this.transactionTemplate.execute(() -> {
            List<ReportEntity> entities = Arrays.asList((ReportEntity[])this.activeObjects.find(ReportEntity.class, Query.select().where("TYPE = ? AND TAG LIKE ?", new Object[]{this.entityType, "%" + tag + "%"})));
            if (entities.isEmpty()) {
                log.debug("Entities with tag {} is not found", (Object)tag);
                return new ArrayList();
            }
            return entities.stream().map(this::convertValue).filter(t -> Arrays.asList(((PluginEntity)((Object)t)).getTag().split(",")).contains(tag)).collect(Collectors.toList());
        });
    }

    @Override
    public T save(T entity) {
        return (T)((ScheduledEntity)this.transactionTemplate.execute(() -> super.save(entity)));
    }

    @Override
    public T delete(int id) {
        return (T)((ScheduledEntity)this.transactionTemplate.execute(() -> (ScheduledEntity)super.delete(id)));
    }

    @Override
    public T deleteByKey(String key) {
        return (T)((ScheduledEntity)this.transactionTemplate.execute(() -> (ScheduledEntity)super.deleteByKey(key)));
    }

    @Override
    public int deleteAll() {
        return (Integer)this.transactionTemplate.execute(() -> super.deleteAll());
    }

    @Override
    public List<T> deleteByTag(String tag) {
        return (List)this.transactionTemplate.execute(() -> super.deleteByTag(tag));
    }

    @Override
    public int count() {
        return (Integer)this.transactionTemplate.execute(() -> super.count());
    }

    @Override
    public T getByKey(String key) {
        return (T)((ScheduledEntity)this.transactionTemplate.execute(() -> (ScheduledEntity)super.getByKey(key)));
    }
}

