/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.ao.entity.PluginSettingEntity;
import com.moveworkforward.ao.impl.AbstractPluginSettingRepository;
import com.moveworkforward.util.ConnectorUtil;
import java.util.Arrays;
import java.util.function.Function;
import lombok.Generated;
import net.java.ao.DBParam;
import net.java.ao.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUpgradeTask
implements ActiveObjectsUpgradeTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractUpgradeTask.class);
    protected ObjectMapper objectMapper = ConnectorUtil.createObjectMapper();

    protected <T extends Entity, K extends PluginEntity> void convert(Class<T> aClass, Function<T, K> transformFunction, ActiveObjects activeObjects) {
        Entity[] toTransform = (Entity[])activeObjects.find(aClass);
        if (toTransform == null || toTransform.length == 0) {
            log.info("Nothing to transform");
            return;
        }
        Arrays.asList(toTransform).forEach(s -> {
            PluginEntity newEntity = null;
            try {
                newEntity = (PluginEntity)transformFunction.apply(s);
            }
            catch (Exception e) {
                log.error("Exception while transforming: " + String.valueOf(s), (Throwable)e);
            }
            if (newEntity != null) {
                this.savePluginSetting(newEntity, activeObjects);
            } else {
                log.error(String.valueOf(s) + " has not been transformed, nothing to save");
            }
        });
    }

    protected <M extends PluginEntity> void savePluginSetting(M newEntity, ActiveObjects activeObjects) {
        try {
            PluginSettingEntity pluginSetting = (PluginSettingEntity)activeObjects.create(PluginSettingEntity.class, new DBParam[]{new DBParam("TYPE", (Object)AbstractPluginSettingRepository.getType(newEntity.getClass())), new DBParam("KEY", (Object)newEntity.getKey()), new DBParam("TAG", (Object)newEntity.getTag()), new DBParam("CONTENT", (Object)this.objectMapper.writeValueAsString(newEntity))});
            log.info("Configuration: " + pluginSetting.getKey() + " has been added to the list of all configurations");
            pluginSetting.save();
        }
        catch (Exception e) {
            log.error("Can't convert configuration:", (Throwable)e);
        }
    }
}

