/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.v2.ao.converters;

import com.moveworkforward.model.UserSurvey;
import com.moveworkforward.util.ConnectorUtil;
import com.moveworkforward.v2.ao.PersistentConverter;
import com.moveworkforward.v2.model.BasePersistenceEntity;
import lombok.NonNull;

public class UserSurveyConverter
implements PersistentConverter<BasePersistenceEntity, UserSurvey> {
    @Override
    public BasePersistenceEntity convertToAo(UserSurvey target) {
        BasePersistenceEntity persistenceEntity = new BasePersistenceEntity();
        persistenceEntity.setID(target.getId() == null ? 0 : target.getId());
        persistenceEntity.setKey(UserSurveyConverter.getKey(target.getUserKey(), target.getSurveyId()));
        persistenceEntity.setTag(target.getSurveyId());
        persistenceEntity.setType("SURVEY");
        persistenceEntity.setContent(ConnectorUtil.createObjectMapper().writeValueAsString((Object)target));
        return persistenceEntity;
    }

    public static String getKey(@NonNull String userKey, @NonNull String surveyId) {
        if (userKey == null) {
            throw new NullPointerException("userKey is marked non-null but is null");
        }
        if (surveyId == null) {
            throw new NullPointerException("surveyId is marked non-null but is null");
        }
        return userKey + "_" + surveyId;
    }
}

