/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.util;

import com.moveworkforward.model.teams.MessageData;
import com.moveworkforward.model.teams.payload.AbstractBodyItem;
import com.moveworkforward.model.teams.payload.Attachment;
import com.moveworkforward.model.teams.payload.ColumnItem;
import com.moveworkforward.model.teams.payload.ColumnSet;
import com.moveworkforward.model.teams.payload.Container;
import com.moveworkforward.model.teams.payload.Image;
import com.moveworkforward.model.teams.payload.Message;
import com.moveworkforward.model.teams.payload.MicrosoftTeamsActiveCardMessage;
import com.moveworkforward.model.teams.payload.OpenUrlAction;
import com.moveworkforward.model.teams.payload.TextBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamsPayloadUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TeamsPayloadUtils.class);

    public static String makeMicrosoftTeamsLink(String text, String url) {
        return "[" + text + "](" + url + ")";
    }

    public static Message createToggleableItemsMessage(MessageData messageData) {
        MicrosoftTeamsActiveCardMessage microsoftTeamsActiveCardMessage = new MicrosoftTeamsActiveCardMessage(messageData.getTitle());
        microsoftTeamsActiveCardMessage.getBody().add(TextBlock.builder().text(messageData.getTitle()).wrap(true).weight("Bolder").build());
        microsoftTeamsActiveCardMessage.getBody().add(TextBlock.builder().text(messageData.getDescription()).wrap(true).size("Medium").subtle(true).build());
        if (StringUtils.isNotBlank((CharSequence)messageData.getSectionsTitle())) {
            Container sectionsContainer = Container.builder().visible(true).items(new ArrayList<AbstractBodyItem>()).spacing("Large").style("emphasis").bleed(true).build();
            microsoftTeamsActiveCardMessage.getBody().add(sectionsContainer);
            sectionsContainer.getItems().add(new ColumnSet(new ColumnSet.Column(ColumnItem.builder().text(messageData.getSectionsTitle()).visible(true).weight("Bolder").build())));
        }
        messageData.getItems().forEach(messageItem -> TeamsPayloadUtils.addMessageItems(microsoftTeamsActiveCardMessage.getBody(), messageItem));
        messageData.getActions().forEach(action -> microsoftTeamsActiveCardMessage.getActions().add(new OpenUrlAction(action.getTitle(), action.getUrl())));
        return new Message(new Attachment(microsoftTeamsActiveCardMessage));
    }

    public static void addMessageItems(List<AbstractBodyItem> body, MessageData.Item messageItem) {
        List content = messageItem.getContent();
        if (StringUtils.isNotBlank((CharSequence)messageItem.getHeader())) {
            Container sectionsContainer = Container.builder().visible(true).items(new ArrayList<AbstractBodyItem>()).spacing("Large").style("emphasis").bleed(true).build();
            body.add(sectionsContainer);
            sectionsContainer.getItems().add(new ColumnSet(new ColumnSet.Column(ColumnItem.builder().text(messageItem.getHeader()).visible(true).weight("Bolder").build())));
        }
        Container container = new Container();
        body.add(container);
        ColumnSet columnSet = new ColumnSet();
        container.getItems().add(columnSet);
        columnSet.getColumns().add(new ColumnSet.Column(ColumnItem.builder().text(StringUtils.isBlank((CharSequence)messageItem.getTitle()) ? " " : messageItem.getTitle()).visible(true).wrap(true).build()));
        boolean contentAsColumns = false;
        if (CollectionUtils.isEmpty(content)) {
            log.debug("No content for: {}", (Object)messageItem.getId());
            return;
        }
        contentAsColumns = content.get(0) instanceof Collection;
        String typeId = messageItem.getId().replace(" ", "_");
        boolean toggleAdded = TeamsPayloadUtils.addToggleLinks(messageItem, columnSet, typeId);
        ArrayList<AbstractBodyItem> items = new ArrayList<AbstractBodyItem>();
        if (contentAsColumns) {
            content.forEach(o -> {
                ColumnSet contentColumnSet = new ColumnSet();
                ArrayList values = new ArrayList((Collection)o);
                values.forEach(value -> {
                    ColumnSet.Column column = null;
                    if (value instanceof MessageData.WidthContent) {
                        MessageData.WidthContent widthContent = (MessageData.WidthContent)value;
                        column = ColumnSet.Column.builder().width(widthContent.getWidth()).items(new ArrayList<ColumnItem>()).build();
                    } else {
                        column = ColumnSet.Column.builder().items(new ArrayList<ColumnItem>()).build();
                    }
                    contentColumnSet.getColumns().add(column);
                    if (value instanceof MessageData.ImageContent) {
                        MessageData.ImageContent imageContent = (MessageData.ImageContent)value;
                        column.getItems().add(ColumnItem.builder().visible(true).type("Image").altText(imageContent.getAltText()).url(imageContent.getUrl()).build());
                    } else {
                        column.getItems().add(ColumnItem.builder().visible(true).wrap(true).text(String.valueOf(value)).build());
                    }
                });
                items.add(contentColumnSet);
            });
        } else {
            items.addAll(content.stream().map(item -> {
                if (item instanceof MessageData.ImageContent) {
                    MessageData.ImageContent imageContent = (MessageData.ImageContent)item;
                    return Image.builder().altText(imageContent.getAltText()).url(imageContent.getUrl()).build();
                }
                return TextBlock.builder().text(String.valueOf(item)).subtle(false).wrap(true).build();
            }).collect(Collectors.toList()));
        }
        container.getItems().add(Container.builder().id("cardContent-" + typeId).visible(!toggleAdded || messageItem.isExpanded()).items(items).build());
    }

    private static boolean addToggleLinks(MessageData.Item messageItem, ColumnSet columnSet, String typeId) {
        if (StringUtils.isBlank((CharSequence)messageItem.getShowText()) || StringUtils.isBlank((CharSequence)messageItem.getHideText())) {
            return false;
        }
        ColumnSet.Column toggleColumn = ColumnSet.Column.builder().width("auto").spacing("Small").items(new ArrayList<ColumnItem>()).build();
        toggleColumn.setSelectAction(new ColumnSet.SelectAction("cardContent-" + typeId, "chevronDown-" + typeId, "chevronUp-" + typeId));
        toggleColumn.getItems().add(ColumnItem.builder().wrap(true).color("Accent").visible(!messageItem.isExpanded()).id("chevronDown-" + typeId).text(messageItem.getShowText()).build());
        toggleColumn.getItems().add(ColumnItem.builder().wrap(true).color("Accent").visible(messageItem.isExpanded()).id("chevronUp-" + typeId).text(messageItem.getHideText()).build());
        columnSet.getColumns().add(toggleColumn);
        return true;
    }
}

