/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.util;

import java.lang.reflect.Constructor;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.atomic.AtomicBoolean;

public final class JwtUtil {
    private static final String REQUIRED_CLASS = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static final ClassLoaderAccessor THREAD_CL_ACCESSOR = new ExceptionIgnoringAccessor(){

        @Override
        protected ClassLoader doGetClassLoader() throws Throwable {
            return Thread.currentThread().getContextClassLoader();
        }
    };
    private static final ClassLoaderAccessor CLASS_CL_ACCESSOR = new ExceptionIgnoringAccessor(){

        @Override
        protected ClassLoader doGetClassLoader() throws Throwable {
            return JwtUtil.class.getClassLoader();
        }
    };
    private static final ClassLoaderAccessor SYSTEM_CL_ACCESSOR = new ExceptionIgnoringAccessor(){

        @Override
        protected ClassLoader doGetClassLoader() throws Throwable {
            return ClassLoader.getSystemClassLoader();
        }
    };
    private static final AtomicBoolean bcLoaded = new AtomicBoolean(false);
    public static final boolean BOUNCY_CASTLE_AVAILABLE = JwtUtil.isAvailable("org.bouncycastle.jce.provider.BouncyCastleProvider");

    private JwtUtil() {
    }

    public static boolean isAvailable(String fullyQualifiedClassName) {
        try {
            JwtUtil.forName(fullyQualifiedClassName);
            return true;
        }
        catch (Exception var2) {
            return false;
        }
    }

    public static void enableBouncyCastleIfPossible() {
        if (BOUNCY_CASTLE_AVAILABLE && !bcLoaded.get()) {
            try {
                Provider[] providers;
                Class clazz = JwtUtil.forName(REQUIRED_CLASS);
                Provider[] arr$ = providers = Security.getProviders();
                int len$ = providers.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Provider provider = arr$[i$];
                    if (!clazz.isInstance(provider)) continue;
                    bcLoaded.set(true);
                    return;
                }
                Security.addProvider((Provider)JwtUtil.newInstance(clazz));
                bcLoaded.set(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static <T> Class<T> forName(String fqcn) throws RuntimeException {
        Class clazz = THREAD_CL_ACCESSOR.loadClass(fqcn);
        if (clazz == null) {
            clazz = CLASS_CL_ACCESSOR.loadClass(fqcn);
        }
        if (clazz == null) {
            clazz = SYSTEM_CL_ACCESSOR.loadClass(fqcn);
        }
        if (clazz == null) {
            String msg = "Unable to load class named [" + fqcn + "] from the thread context, current, or system/application ClassLoaders.  All heuristics have been exhausted.  Class could not be found.";
            if (fqcn != null && fqcn.startsWith("io.jsonwebtoken.impl")) {
                msg = msg + "  Have you remembered to include the jjwt-impl.jar in your runtime classpath?";
            }
            throw new RuntimeException(msg);
        }
        return clazz;
    }

    public static <T> T newInstance(String fqcn) {
        return JwtUtil.newInstance(JwtUtil.forName(fqcn));
    }

    public static <T> T newInstance(String fqcn, Class[] ctorArgTypes, Object ... args) {
        Class<T> clazz = JwtUtil.forName(fqcn);
        Constructor<T> ctor = JwtUtil.getConstructor(clazz, ctorArgTypes);
        return JwtUtil.instantiate(ctor, args);
    }

    public static <T> T newInstance(String fqcn, Object ... args) {
        return JwtUtil.newInstance(JwtUtil.forName(fqcn), args);
    }

    public static <T> T newInstance(Class<T> clazz) {
        if (clazz == null) {
            String msg = "Class method parameter cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception var2) {
            throw new RuntimeException("Unable to instantiate class [" + clazz.getName() + "]", var2);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        Constructor<T> ctor = JwtUtil.getConstructor(clazz, argTypes);
        return JwtUtil.instantiate(ctor, args);
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class ... argTypes) {
        try {
            return clazz.getConstructor(argTypes);
        }
        catch (NoSuchMethodException var3) {
            throw new IllegalStateException(var3);
        }
    }

    public static <T> T instantiate(Constructor<T> ctor, Object ... args) {
        try {
            return ctor.newInstance(args);
        }
        catch (Exception var4) {
            String msg = "Unable to instantiate instance with constructor [" + ctor + "]";
            throw new RuntimeException(msg, var4);
        }
    }

    private static interface ClassLoaderAccessor {
        public Class loadClass(String var1);
    }

    private static abstract class ExceptionIgnoringAccessor
    implements ClassLoaderAccessor {
        private ExceptionIgnoringAccessor() {
        }

        @Override
        public Class loadClass(String fqcn) {
            Class<?> clazz = null;
            ClassLoader cl = this.getClassLoader();
            if (cl != null) {
                try {
                    clazz = cl.loadClass(fqcn);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return clazz;
        }

        protected final ClassLoader getClassLoader() {
            try {
                return this.doGetClassLoader();
            }
            catch (Throwable var2) {
                return null;
            }
        }

        protected abstract ClassLoader doGetClassLoader() throws Throwable;
    }
}

