/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.vfs.Vfs;

public class JavaUtils {
    public static Set<String> getAnnotatedProperties(Class<?> clazz, Class<? extends Annotation> annotationType) {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        while (clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(annotationType)) continue;
                fields.add(field.getName());
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static Set<Class<?>> getClassesWithAnnotation(String packageName, Class<? extends Annotation> annotationType) {
        if (annotationType == null) {
            return Collections.emptySet();
        }
        Reflections reflections = new Reflections(new ConfigurationBuilder().forPackages(packageName).setScanners(new SubTypesScanner(), new TypeAnnotationsScanner()));
        return reflections.getTypesAnnotatedWith(annotationType);
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(JavaUtils.class);
        Vfs.addDefaultURLTypes(new BundleUrlType(bundle));
    }

    public static class BundleUrlType
    implements Vfs.UrlType {
        public static final String BUNDLE_PROTOCOL = "bundle";
        private final Bundle bundle;

        public BundleUrlType(Bundle bundle) {
            this.bundle = bundle;
        }

        @Override
        public boolean matches(URL url) {
            return BUNDLE_PROTOCOL.equals(url.getProtocol());
        }

        @Override
        public Vfs.Dir createDir(URL url) {
            return new BundleDir(this.bundle, url);
        }

        public class BundleDir
        implements Vfs.Dir {
            private final Bundle bundle;
            private String path;

            public BundleDir(Bundle bundle, URL url) {
                this(bundle, url.getPath());
            }

            public BundleDir(Bundle bundle, String p) {
                this.bundle = bundle;
                this.path = p;
                if (this.path.startsWith("bundle:")) {
                    this.path = this.path.substring("bundle:".length());
                }
            }

            @Override
            public String getPath() {
                return this.path;
            }

            @Override
            public Iterable<Vfs.File> getFiles() {
                return () -> new Iterator<Vfs.File>(){
                    final Enumeration<URL> entries;
                    {
                        this.entries = BundleDir.this.bundle.findEntries(BundleDir.this.path, "*.class", true);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.entries.hasMoreElements();
                    }

                    @Override
                    public Vfs.File next() {
                        return new BundleFile(BundleDir.this, this.entries.nextElement());
                    }
                };
            }

            @Override
            public void close() {
            }
        }

        public class BundleFile
        implements Vfs.File {
            private final BundleDir dir;
            private final String name;
            private final URL url;

            public BundleFile(BundleDir dir, URL url) {
                this.dir = dir;
                this.url = url;
                String path = url.getFile();
                this.name = path.substring(path.lastIndexOf("/") + 1);
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public String getRelativePath() {
                return this.getFullPath().substring(this.dir.getPath().length());
            }

            public String getFullPath() {
                return this.url.getFile();
            }

            @Override
            public InputStream openInputStream() throws IOException {
                return this.url.openStream();
            }
        }
    }
}

