/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.statistics.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.moveworkforward.statistics.model.RuleData;
import com.moveworkforward.statistics.model.Tenant;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
public class StatisticsMessage {
    private String id = UUID.randomUUID().toString();
    private String version = "1.0";
    private Tenant tenant;
    private InstallationData installationData;
    private StatisticsData data;

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Tenant getTenant() {
        return this.tenant;
    }

    @Generated
    public InstallationData getInstallationData() {
        return this.installationData;
    }

    @Generated
    public StatisticsData getData() {
        return this.data;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    @Generated
    public void setInstallationData(InstallationData installationData) {
        this.installationData = installationData;
    }

    @Generated
    public void setData(StatisticsData data) {
        this.data = data;
    }

    @JsonAutoDetect
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class InstallationData {
        private Date installedOn;
        private Date enabledOn;

        @Generated
        public Date getInstalledOn() {
            return this.installedOn;
        }

        @Generated
        public Date getEnabledOn() {
            return this.enabledOn;
        }

        @Generated
        public void setInstalledOn(Date installedOn) {
            this.installedOn = installedOn;
        }

        @Generated
        public void setEnabledOn(Date enabledOn) {
            this.enabledOn = enabledOn;
        }
    }

    @JsonAutoDetect
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class StatisticsData {
        private Period period;
        private Map<String, Rules> features = new LinkedHashMap<String, Rules>();

        @Generated
        public Period getPeriod() {
            return this.period;
        }

        @Generated
        public Map<String, Rules> getFeatures() {
            return this.features;
        }

        @Generated
        public void setPeriod(Period period) {
            this.period = period;
        }

        @Generated
        public void setFeatures(Map<String, Rules> features) {
            this.features = features;
        }
    }

    @JsonAutoDetect
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RulesStatistics {
        private int amount;
        private Map<String, Object> propertyStatistics = new HashMap<String, Object>();

        public RulesStatistics(RuleData ruleData) {
            this.amount = ruleData.getAmount();
            this.propertyStatistics = ruleData.getPropertyStatistics();
        }

        @Generated
        public int getAmount() {
            return this.amount;
        }

        @Generated
        public Map<String, Object> getPropertyStatistics() {
            return this.propertyStatistics;
        }

        @Generated
        public void setAmount(int amount) {
            this.amount = amount;
        }

        @Generated
        public void setPropertyStatistics(Map<String, Object> propertyStatistics) {
            this.propertyStatistics = propertyStatistics;
        }

        @Generated
        public RulesStatistics() {
        }
    }

    @JsonAutoDetect
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Rules {
        private int total;
        private Map<String, Object> propertyStatistics;
        private Map<String, RulesStatistics> created;
        private Map<String, RulesStatistics> updated;
        private Map<String, RulesStatistics> deleted;

        public boolean isEmpty() {
            return this.total == 0 && MapUtils.isEmpty(this.created) && MapUtils.isEmpty(this.updated) && MapUtils.isEmpty(this.deleted);
        }

        @Generated
        public int getTotal() {
            return this.total;
        }

        @Generated
        public Map<String, Object> getPropertyStatistics() {
            return this.propertyStatistics;
        }

        @Generated
        public Map<String, RulesStatistics> getCreated() {
            return this.created;
        }

        @Generated
        public Map<String, RulesStatistics> getUpdated() {
            return this.updated;
        }

        @Generated
        public Map<String, RulesStatistics> getDeleted() {
            return this.deleted;
        }

        @Generated
        public void setTotal(int total) {
            this.total = total;
        }

        @Generated
        public void setPropertyStatistics(Map<String, Object> propertyStatistics) {
            this.propertyStatistics = propertyStatistics;
        }

        @Generated
        public void setCreated(Map<String, RulesStatistics> created) {
            this.created = created;
        }

        @Generated
        public void setUpdated(Map<String, RulesStatistics> updated) {
            this.updated = updated;
        }

        @Generated
        public void setDeleted(Map<String, RulesStatistics> deleted) {
            this.deleted = deleted;
        }
    }

    @JsonAutoDetect
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Period {
        private Date from;
        private Date to;

        @Generated
        public Date getFrom() {
            return this.from;
        }

        @Generated
        public Date getTo() {
            return this.to;
        }

        @Generated
        public void setFrom(Date from) {
            this.from = from;
        }

        @Generated
        public void setTo(Date to) {
            this.to = to;
        }
    }
}

