/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.statistics.ao.converter;

import com.moveworkforward.service.OperationListener;
import com.moveworkforward.statistics.model.RuleData;
import com.moveworkforward.util.ConnectorUtil;
import com.moveworkforward.v2.ao.PersistentConverter;
import com.moveworkforward.v2.model.BasePersistenceEntity;
import lombok.NonNull;

public class RuleDataConverter
implements PersistentConverter<BasePersistenceEntity, RuleData> {
    public static String getKey(@NonNull String configurationType, @NonNull OperationListener.OperationType action, @NonNull String ruleType) {
        if (configurationType == null) {
            throw new NullPointerException("configurationType is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (ruleType == null) {
            throw new NullPointerException("ruleType is marked non-null but is null");
        }
        return configurationType + "_" + action + "_" + ruleType;
    }

    @Override
    public BasePersistenceEntity convertToAo(RuleData target) {
        BasePersistenceEntity persistenceEntity = new BasePersistenceEntity();
        persistenceEntity.setID(target.getId() == null ? 0 : target.getId());
        persistenceEntity.setKey(RuleDataConverter.getKey(target.getConfigurationType(), target.getAction(), target.getRuleType()));
        persistenceEntity.setTag(target.getRuleType().toString());
        persistenceEntity.setType("RULE_DATA");
        persistenceEntity.setContent(ConnectorUtil.createObjectMapper().writeValueAsString((Object)target));
        return persistenceEntity;
    }
}

