/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.license;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.moveworkforward.license.LicenseManager;
import com.moveworkforward.util.MwfPropertyUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class LicenseManagerImpl
implements LicenseManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseManagerImpl.class);
    private final boolean isDevMode;
    private final PluginLicenseManager pluginLicenseManager;

    @Autowired
    public LicenseManagerImpl(@ComponentImport PluginLicenseManager pluginLicenseManager, Environment environment) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.isDevMode = MwfPropertyUtils.getInstance().isDevMode(environment);
    }

    @Override
    public boolean isLicensed() {
        boolean result = true;
        String pluginKey = this.pluginLicenseManager.getPluginKey();
        if (this.isDevMode) {
            log.info("{}: License check is skipped", (Object)pluginKey);
        } else {
            Option license = this.pluginLicenseManager.getLicense();
            boolean bl = result = license.isDefined() && ((PluginLicense)license.get()).isValid();
        }
        if (result) {
            log.info("{}: Plugin licensed.", (Object)pluginKey);
        } else {
            log.error("{}: There is no valid licence", (Object)pluginKey);
        }
        return result;
    }
}

