/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.component;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.moveworkforward.component.UserSurveyManager;
import com.moveworkforward.model.SurveySettings;
import com.moveworkforward.model.User;
import com.moveworkforward.model.UserSurvey;
import com.moveworkforward.v2.ao.converters.UserSurveyConverter;
import com.moveworkforward.v2.ao.impl.UserSurveyRepository;
import com.moveworkforward.v2.validation.RecordValidator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUserSurveyManager
implements UserSurveyManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractUserSurveyManager.class);
    protected final ApplicationProperties applicationProperties;
    protected final PluginLicenseManager pluginLicenseManager;
    protected final PluginSettings pluginSettings;
    protected final PluginAccessor pluginAccessor;
    protected final UserSurveyRepository surveyRepository;
    protected final RecordValidator recordValidator;

    public AbstractUserSurveyManager(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport PluginAccessor pluginAccessor, UserSurveyRepository surveyRepository, RecordValidator recordValidator) {
        this.applicationProperties = applicationProperties;
        this.pluginLicenseManager = pluginLicenseManager;
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey(this.getPluginSettingsKey());
        this.pluginAccessor = pluginAccessor;
        this.surveyRepository = surveyRepository;
        this.recordValidator = recordValidator;
    }

    @Override
    public UserSurvey save(UserSurvey survey) {
        this.recordValidator.validate(survey);
        return this.surveyRepository.save(survey);
    }

    @Override
    public UserSurvey getSurvey(String userKey, String surveyId) {
        return this.surveyRepository.getByKey(UserSurveyConverter.getKey(userKey, surveyId), UserSurvey.class);
    }

    @Override
    public SurveySettings getSurveySettings() {
        return Optional.ofNullable(this.surveyRepository.getByKey("SURVEY_SETTINGS", SurveySettings.class)).orElse(new SurveySettings());
    }

    @Override
    public void resetSurvey(String surveyId) {
        this.surveyRepository.deleteByTag(surveyId, UserSurvey.class);
    }

    @Override
    public UserSurvey submitSurvey(String userKey, String surveyId) {
        UserSurvey survey = this.getSurvey(userKey, surveyId);
        survey = survey == null ? new UserSurvey() : survey;
        survey.setUserKey(userKey);
        survey.setSurveyId(surveyId);
        survey.setSubmittedAt(new Date());
        survey.setSubmitCount(survey.getSubmitCount() + 1);
        survey.setCancelCount(0);
        survey.setCancelledAt(null);
        return this.save(survey);
    }

    @Override
    public UserSurvey cancelSurvey(String userKey, String surveyId) {
        UserSurvey survey = this.getSurvey(userKey, surveyId);
        survey = survey == null ? new UserSurvey() : survey;
        survey.setUserKey(userKey);
        survey.setSurveyId(surveyId);
        survey.setCancelledAt(new Date());
        survey.setCancelCount(survey.getCancelCount() + 1);
        survey.setSubmitCount(0);
        survey.setSubmittedAt(null);
        return this.save(survey);
    }

    @Override
    public Map<String, Object> getSurveyData(User user, String surveyId, Location location) {
        try {
            if (this.showSurvey(user.getUserKey(), surveyId)) {
                return this.buildSurveyData(location, user, surveyId);
            }
            return null;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected boolean showSurvey(String userKey, String surveyId) {
        SurveySettings settings = this.getSurveySettings();
        if (!settings.isEnabled()) {
            log.debug("Survey is disabled");
            return false;
        }
        UserSurvey survey = this.getSurvey(userKey, surveyId);
        Date now = new Date();
        Date installationDate = this.getInstallationDate();
        if (this.isEvaluationLicense()) {
            if (survey == null || survey.getSubmittedAt() == null && survey.getCancelledAt() == null) {
                return now.getTime() - installationDate.getTime() > settings.getEvaluationCancellationPeriod();
            }
            if (survey.getSubmittedAt() != null) {
                return now.getTime() - survey.getSubmittedAt().getTime() > settings.getSubmissionPeriod();
            }
            return now.getTime() - survey.getCancelledAt().getTime() > settings.getEvaluationCancellationPeriod();
        }
        if (survey == null || survey.getSubmittedAt() == null && survey.getCancelledAt() == null) {
            return true;
        }
        if (survey.getSubmittedAt() != null) {
            return now.getTime() - survey.getSubmittedAt().getTime() > settings.getSubmissionPeriod();
        }
        return now.getTime() - survey.getCancelledAt().getTime() > settings.getLicenseCancellationPeriod();
    }

    private Date getInstallationDate() {
        try {
            Plugin plugin = this.pluginAccessor.getPlugin(this.getPluginKey());
            if (plugin != null && plugin.getDateInstalled() != null) {
                return plugin.getDateInstalled();
            }
            log.warn("Plugin '{}' installation date is not detected", (Object)this.getPluginKey());
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        return new Date();
    }

    private boolean isEvaluationLicense() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            return ((PluginLicense)this.pluginLicenseManager.getLicense().get()).isEvaluation();
        }
        return true;
    }

    protected Map<String, Object> buildSurveyData(Location location, User user, String surveyId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("form_id", surveyId);
        result.put("base_url", this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE));
        result.put("user_id", user.getUserKey());
        result.put("survey_type", this.getSurveyType());
        result.put("location", location.getKey());
        result.put("app_id", this.getPluginKey());
        String tenantId = this.getTenantId();
        result.put("tenant_id", tenantId);
        result.put("hosting_type", "DC");
        try {
            result.put("app_version", this.pluginAccessor.getPlugin(this.getPluginKey()).getPluginInformation().getVersion());
            this.getUserEmail(user).ifPresent(email -> result.put("email", email));
            this.getUserRole(user).ifPresent(role -> result.put("user_role", role));
            if (this.pluginLicenseManager.getLicense().isDefined()) {
                PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
                result.put("license_status", license.isActive() ? "active" : "inactive");
                result.put("sen", license.getSupportEntitlementNumber().getOrElse((Object)"unknown"));
                result.put("license_type", license.isEvaluation() ? "evaluation" : "commercial");
            } else {
                log.debug("License is not defined");
                result.put("license_status", "inactive");
                result.put("license_type", "evaluation");
                result.put("sen", "unknown");
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected abstract Optional<String> getUserRole(User var1);

    protected abstract Optional<String> getUserEmail(User var1);

    private String getSurveyType() {
        return "nps-survey";
    }

    @Override
    public String getTenantId() {
        String clientKey = (String)this.pluginSettings.get(this.getTenantKey());
        if (StringUtils.isBlank((CharSequence)clientKey)) {
            clientKey = UUID.randomUUID().toString();
            this.pluginSettings.put(this.getTenantKey(), (Object)clientKey);
        }
        return clientKey;
    }

    @Override
    public List<UserSurvey> getSurveys(String surveyId) {
        return this.surveyRepository.getByTag(surveyId, UserSurvey.class);
    }

    @Override
    public SurveySettings resetSettings() {
        SurveySettings surveySettings = this.getSurveySettings();
        surveySettings.setEvaluationCancellationPeriod(604800000L);
        surveySettings.setLicenseCancellationPeriod(1209600000L);
        surveySettings.setSubmissionPeriod(7776000000L);
        surveySettings.setEnabled(true);
        return this.saveSurveySettings(surveySettings);
    }

    @Override
    public SurveySettings saveSurveySettings(SurveySettings surveySettings) {
        return this.surveyRepository.save(surveySettings);
    }

    protected abstract String getTenantKey();

    protected abstract String getPluginSettingsKey();

    protected abstract String getPluginKey();

    public static interface Location {
        public String getKey();
    }
}

