/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.v2.service.impl;

import com.moveworkforward.model.ConfigurationAudit;
import com.moveworkforward.model.User;
import com.moveworkforward.v2.ao.PluginRepository;
import com.moveworkforward.v2.model.IdModel;
import com.moveworkforward.v2.service.ConfigurationService;
import com.moveworkforward.v2.validation.ValidationHelper;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurationService<T extends IdModel>
implements ConfigurationService<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractConfigurationService.class);
    protected final PluginRepository pluginRepository;
    protected final ValidationHelper<T> validationHelper;
    private final Class<T> persistentClass;

    public AbstractConfigurationService(PluginRepository pluginRepository, ValidationHelper<T> validationHelper) {
        this.pluginRepository = pluginRepository;
        this.validationHelper = validationHelper;
        this.persistentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    @Override
    public T save(T target) {
        IdModel existingEntity;
        ConfigurationAudit.OperationType operationType;
        this.validate(target);
        ConfigurationAudit.OperationType operationType2 = operationType = target.getId() == null || target.getId() == 0 ? ConfigurationAudit.OperationType.NEW : ConfigurationAudit.OperationType.UPDATE;
        if (ConfigurationAudit.OperationType.UPDATE.equals((Object)operationType) && (existingEntity = (IdModel)this.pluginRepository.get(target.getId(), this.persistentClass)) != null) {
            this.validationHelper.checkWritePermissions(existingEntity);
        }
        this.validationHelper.checkWritePermissions(target);
        IdModel result = (IdModel)this.pluginRepository.save(target);
        return (T)result;
    }

    @Override
    public T get(int id) {
        IdModel result = (IdModel)this.pluginRepository.get(id, this.persistentClass);
        if (result == null) {
            throw new RuntimeException("Record is not found by id: " + id);
        }
        this.validationHelper.checkReadPermissions(result);
        return (T)result;
    }

    @Override
    public T delete(int id) {
        IdModel result = (IdModel)this.pluginRepository.get(id, this.persistentClass);
        if (result == null) {
            throw new RuntimeException("Record is not found by id: " + id);
        }
        this.validationHelper.checkDeletePermissions(result);
        return (T)((IdModel)this.pluginRepository.delete(id, this.persistentClass));
    }

    @Override
    public List<T> getAll() {
        boolean hasTagPermission = this.validationHelper.hasTagPermission(null, null);
        List<T> result = this.pluginRepository.getAll(this.persistentClass);
        result = hasTagPermission ? result : this.filter(result);
        return result;
    }

    @Override
    public List<T> getByTag(String tag, String level) {
        boolean hasTagPermission = this.validationHelper.hasTagPermission(tag, level);
        List<T> result = this.pluginRepository.getByTag(tag, this.persistentClass);
        result = hasTagPermission ? result : this.filter(result);
        return result;
    }

    protected void validate(T target) {
        this.validationHelper.validate(target);
    }

    protected List<T> filter(List<T> entities) {
        User user = this.validationHelper.getCurrentUser();
        return entities.stream().filter((? super T t) -> this.validationHelper.hasReadPermissions((IdModel)t, user)).collect(Collectors.toList());
    }
}

