/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.core.env.Environment;

public class PropertyUtils {
    public static final List<String> DEV_PROPERTIES = Collections.unmodifiableList(Arrays.asList("moveworkforward.dev.mode", "mwfDevMode"));
    public static final List<String> DEV_UI_PROPERTIES = Collections.unmodifiableList(Arrays.asList("moveworkforward.dev.local.ui", "mwfDevLocalUi"));

    public static boolean isDevMode(Environment environment) {
        boolean result = DEV_PROPERTIES.stream().anyMatch(prop -> (Boolean)environment.getProperty(prop, Boolean.class, (Object)false));
        return result;
    }

    public static boolean isDevMode() {
        boolean result = DEV_PROPERTIES.stream().anyMatch(prop -> Boolean.parseBoolean(System.getProperty(prop, "false")));
        return result;
    }

    public static boolean isDevLocalUi(Environment environment) {
        boolean result = DEV_UI_PROPERTIES.stream().anyMatch(prop -> (Boolean)environment.getProperty(prop, Boolean.class, (Object)false));
        return result;
    }

    public static boolean isDevLocalUi() {
        boolean result = DEV_UI_PROPERTIES.stream().anyMatch(prop -> Boolean.parseBoolean(System.getProperty(prop, "false")));
        return result;
    }
}

