/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.service.impl;

import com.moveworkforward.ao.AuditRepository;
import com.moveworkforward.ao.PluginSettingRepository;
import com.moveworkforward.exception.DetailedException;
import com.moveworkforward.model.AbstractGlobalSettings;
import com.moveworkforward.model.AbstractPluginEntity;
import com.moveworkforward.model.ConfigurationAudit;
import com.moveworkforward.service.GlobalSettingsService;
import com.moveworkforward.service.impl.AbstractConfigurationAuditService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractGlobalSettingsService<T extends AbstractGlobalSettings>
implements GlobalSettingsService<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractGlobalSettingsService.class);
    protected final PluginSettingRepository<T> repository;
    private final AuditRepository auditRepository;

    public AbstractGlobalSettingsService(PluginSettingRepository<T> repository, AuditRepository auditRepository) {
        this.repository = repository;
        this.auditRepository = auditRepository;
    }

    @Override
    public T get(boolean checkPermissions) {
        if (checkPermissions) {
            this.hasUserAdminPermissions();
        }
        return (T)((AbstractGlobalSettings)this.repository.getAll().stream().findFirst().orElse(this.getDefaultSettings()));
    }

    @Override
    public T delete(boolean checkPermissions) {
        AbstractGlobalSettings settings;
        if (checkPermissions) {
            this.hasUserAdminPermissions();
        }
        if ((settings = (AbstractGlobalSettings)this.repository.getAll().stream().findFirst().orElse(null)) == null) {
            log.info("Nothing to remove, global settings has not been saved yet");
            return null;
        }
        AbstractGlobalSettings result = (AbstractGlobalSettings)this.repository.delete(settings.getId());
        AbstractConfigurationAuditService.performAudit(result, ConfigurationAudit.OperationType.DELETE, result, this.auditRepository, this.getUser());
        return (T)result;
    }

    protected abstract String getUser();

    @Override
    public T save(T entity, boolean checkPermissions) {
        if (checkPermissions) {
            this.hasUserAdminPermissions();
        }
        this.validate(entity);
        AbstractGlobalSettings existingEntity = this.repository.getAll().stream().findFirst().orElse(null);
        ConfigurationAudit.OperationType operationType = ConfigurationAudit.OperationType.NEW;
        if (existingEntity != null) {
            operationType = ConfigurationAudit.OperationType.UPDATE;
            this.merge(existingEntity, entity);
        }
        AbstractGlobalSettings result = (AbstractGlobalSettings)this.repository.save(entity);
        AbstractConfigurationAuditService.performAudit(result, operationType, result, this.auditRepository, this.getUser());
        return (T)result;
    }

    protected void merge(T existingEntity, T newEntity) {
        ((AbstractPluginEntity)newEntity).setId(((AbstractPluginEntity)existingEntity).getId());
    }

    protected abstract void hasUserAdminPermissions();

    protected abstract T getDefaultSettings();

    protected void validate(T entity) {
        if (((AbstractGlobalSettings)entity).isAppEnabledInEntitites() && ((AbstractGlobalSettings)entity).isAppDisabledInEntities() && CollectionUtils.containsAny(((AbstractGlobalSettings)entity).getAllowedKeys(), ((AbstractGlobalSettings)entity).getIgnoredKeys())) {
            throw new DetailedException("The same key can not be used in allowed and ignored keys", "appEnabledInEntitites", "appDisabledInEntities");
        }
    }
}

