/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.report;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.moveworkforward.report.ScheduledReportExecutor;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ScheduledReportJobRunner
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(ScheduledReportJobRunner.class);
    @Autowired(required=false)
    private List<ScheduledReportExecutor> scheduledReportExecutors;

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        if (jobRunnerRequest.isCancellationRequested() || CollectionUtils.isEmpty(this.scheduledReportExecutors)) {
            return JobRunnerResponse.success();
        }
        try {
            this.scheduledReportExecutors.parallelStream().forEach(service -> {
                try {
                    log.debug("Running job for: {}", (Object)service.getClass().getSimpleName());
                    service.executeReports();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return JobRunnerResponse.success();
    }
}

