/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.model;

import com.moveworkforward.model.AbstractScheduledReportConfiguration;
import com.moveworkforward.model.TimePeriod;
import java.time.ZoneId;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
public class Delivery {
    public static final int DEFAULT_HOURS_PERIOD = 6;
    private Integer hour;
    private Integer minute;
    private int day;
    private String date;
    private AbstractScheduledReportConfiguration.DeliveryFrequency frequency = AbstractScheduledReportConfiguration.DeliveryFrequency.WEEKLY;
    private int checkHoursPeriod = 6;
    private boolean runEveryTime;
    private boolean runOnWeekends;
    private boolean considerWeekends;
    private boolean deliverOnSchedule;
    private TimePeriod timePeriod;
    private String userTimeZone = ZoneId.systemDefault().getId();
    private String serverTimeZone = ZoneId.systemDefault().getId();

    public Integer getHour() {
        return this.hour == null ? 0 : this.hour;
    }

    public Integer getMinute() {
        return this.minute == null ? 0 : this.minute;
    }

    public static DeliveryBuilder builder() {
        return new DeliveryBuilder();
    }

    public int getDay() {
        return this.day;
    }

    public String getDate() {
        return this.date;
    }

    public AbstractScheduledReportConfiguration.DeliveryFrequency getFrequency() {
        return this.frequency;
    }

    public int getCheckHoursPeriod() {
        return this.checkHoursPeriod;
    }

    public boolean isRunEveryTime() {
        return this.runEveryTime;
    }

    public boolean isRunOnWeekends() {
        return this.runOnWeekends;
    }

    public boolean isConsiderWeekends() {
        return this.considerWeekends;
    }

    public boolean isDeliverOnSchedule() {
        return this.deliverOnSchedule;
    }

    public TimePeriod getTimePeriod() {
        return this.timePeriod;
    }

    public String getUserTimeZone() {
        return this.userTimeZone;
    }

    public String getServerTimeZone() {
        return this.serverTimeZone;
    }

    public void setHour(Integer hour) {
        this.hour = hour;
    }

    public void setMinute(Integer minute) {
        this.minute = minute;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setFrequency(AbstractScheduledReportConfiguration.DeliveryFrequency frequency) {
        this.frequency = frequency;
    }

    public void setCheckHoursPeriod(int checkHoursPeriod) {
        this.checkHoursPeriod = checkHoursPeriod;
    }

    public void setRunEveryTime(boolean runEveryTime) {
        this.runEveryTime = runEveryTime;
    }

    public void setRunOnWeekends(boolean runOnWeekends) {
        this.runOnWeekends = runOnWeekends;
    }

    public void setConsiderWeekends(boolean considerWeekends) {
        this.considerWeekends = considerWeekends;
    }

    public void setDeliverOnSchedule(boolean deliverOnSchedule) {
        this.deliverOnSchedule = deliverOnSchedule;
    }

    public void setTimePeriod(TimePeriod timePeriod) {
        this.timePeriod = timePeriod;
    }

    public void setUserTimeZone(String userTimeZone) {
        this.userTimeZone = userTimeZone;
    }

    public void setServerTimeZone(String serverTimeZone) {
        this.serverTimeZone = serverTimeZone;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Delivery)) {
            return false;
        }
        Delivery other = (Delivery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDay() != other.getDay()) {
            return false;
        }
        if (this.getCheckHoursPeriod() != other.getCheckHoursPeriod()) {
            return false;
        }
        if (this.isRunEveryTime() != other.isRunEveryTime()) {
            return false;
        }
        if (this.isRunOnWeekends() != other.isRunOnWeekends()) {
            return false;
        }
        if (this.isConsiderWeekends() != other.isConsiderWeekends()) {
            return false;
        }
        if (this.isDeliverOnSchedule() != other.isDeliverOnSchedule()) {
            return false;
        }
        Integer this$hour = this.getHour();
        Integer other$hour = other.getHour();
        if (this$hour == null ? other$hour != null : !((Object)this$hour).equals(other$hour)) {
            return false;
        }
        Integer this$minute = this.getMinute();
        Integer other$minute = other.getMinute();
        if (this$minute == null ? other$minute != null : !((Object)this$minute).equals(other$minute)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        AbstractScheduledReportConfiguration.DeliveryFrequency this$frequency = this.getFrequency();
        AbstractScheduledReportConfiguration.DeliveryFrequency other$frequency = other.getFrequency();
        if (this$frequency == null ? other$frequency != null : !((Object)((Object)this$frequency)).equals((Object)other$frequency)) {
            return false;
        }
        TimePeriod this$timePeriod = this.getTimePeriod();
        TimePeriod other$timePeriod = other.getTimePeriod();
        if (this$timePeriod == null ? other$timePeriod != null : !this$timePeriod.equals(other$timePeriod)) {
            return false;
        }
        String this$userTimeZone = this.getUserTimeZone();
        String other$userTimeZone = other.getUserTimeZone();
        if (this$userTimeZone == null ? other$userTimeZone != null : !this$userTimeZone.equals(other$userTimeZone)) {
            return false;
        }
        String this$serverTimeZone = this.getServerTimeZone();
        String other$serverTimeZone = other.getServerTimeZone();
        return !(this$serverTimeZone == null ? other$serverTimeZone != null : !this$serverTimeZone.equals(other$serverTimeZone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Delivery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDay();
        result = result * 59 + this.getCheckHoursPeriod();
        result = result * 59 + (this.isRunEveryTime() ? 79 : 97);
        result = result * 59 + (this.isRunOnWeekends() ? 79 : 97);
        result = result * 59 + (this.isConsiderWeekends() ? 79 : 97);
        result = result * 59 + (this.isDeliverOnSchedule() ? 79 : 97);
        Integer $hour = this.getHour();
        result = result * 59 + ($hour == null ? 43 : ((Object)$hour).hashCode());
        Integer $minute = this.getMinute();
        result = result * 59 + ($minute == null ? 43 : ((Object)$minute).hashCode());
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        AbstractScheduledReportConfiguration.DeliveryFrequency $frequency = this.getFrequency();
        result = result * 59 + ($frequency == null ? 43 : ((Object)((Object)$frequency)).hashCode());
        TimePeriod $timePeriod = this.getTimePeriod();
        result = result * 59 + ($timePeriod == null ? 43 : $timePeriod.hashCode());
        String $userTimeZone = this.getUserTimeZone();
        result = result * 59 + ($userTimeZone == null ? 43 : $userTimeZone.hashCode());
        String $serverTimeZone = this.getServerTimeZone();
        result = result * 59 + ($serverTimeZone == null ? 43 : $serverTimeZone.hashCode());
        return result;
    }

    public String toString() {
        return "Delivery(hour=" + this.getHour() + ", minute=" + this.getMinute() + ", day=" + this.getDay() + ", date=" + this.getDate() + ", frequency=" + (Object)((Object)this.getFrequency()) + ", checkHoursPeriod=" + this.getCheckHoursPeriod() + ", runEveryTime=" + this.isRunEveryTime() + ", runOnWeekends=" + this.isRunOnWeekends() + ", considerWeekends=" + this.isConsiderWeekends() + ", deliverOnSchedule=" + this.isDeliverOnSchedule() + ", timePeriod=" + this.getTimePeriod() + ", userTimeZone=" + this.getUserTimeZone() + ", serverTimeZone=" + this.getServerTimeZone() + ")";
    }

    public Delivery() {
    }

    public Delivery(Integer hour, Integer minute, int day, String date, AbstractScheduledReportConfiguration.DeliveryFrequency frequency, int checkHoursPeriod, boolean runEveryTime, boolean runOnWeekends, boolean considerWeekends, boolean deliverOnSchedule, TimePeriod timePeriod, String userTimeZone, String serverTimeZone) {
        this.hour = hour;
        this.minute = minute;
        this.day = day;
        this.date = date;
        this.frequency = frequency;
        this.checkHoursPeriod = checkHoursPeriod;
        this.runEveryTime = runEveryTime;
        this.runOnWeekends = runOnWeekends;
        this.considerWeekends = considerWeekends;
        this.deliverOnSchedule = deliverOnSchedule;
        this.timePeriod = timePeriod;
        this.userTimeZone = userTimeZone;
        this.serverTimeZone = serverTimeZone;
    }

    public static class DeliveryBuilder {
        private Integer hour;
        private Integer minute;
        private int day;
        private String date;
        private AbstractScheduledReportConfiguration.DeliveryFrequency frequency;
        private int checkHoursPeriod;
        private boolean runEveryTime;
        private boolean runOnWeekends;
        private boolean considerWeekends;
        private boolean deliverOnSchedule;
        private TimePeriod timePeriod;
        private String userTimeZone;
        private String serverTimeZone;

        DeliveryBuilder() {
        }

        public DeliveryBuilder hour(Integer hour) {
            this.hour = hour;
            return this;
        }

        public DeliveryBuilder minute(Integer minute) {
            this.minute = minute;
            return this;
        }

        public DeliveryBuilder day(int day) {
            this.day = day;
            return this;
        }

        public DeliveryBuilder date(String date) {
            this.date = date;
            return this;
        }

        public DeliveryBuilder frequency(AbstractScheduledReportConfiguration.DeliveryFrequency frequency) {
            this.frequency = frequency;
            return this;
        }

        public DeliveryBuilder checkHoursPeriod(int checkHoursPeriod) {
            this.checkHoursPeriod = checkHoursPeriod;
            return this;
        }

        public DeliveryBuilder runEveryTime(boolean runEveryTime) {
            this.runEveryTime = runEveryTime;
            return this;
        }

        public DeliveryBuilder runOnWeekends(boolean runOnWeekends) {
            this.runOnWeekends = runOnWeekends;
            return this;
        }

        public DeliveryBuilder considerWeekends(boolean considerWeekends) {
            this.considerWeekends = considerWeekends;
            return this;
        }

        public DeliveryBuilder deliverOnSchedule(boolean deliverOnSchedule) {
            this.deliverOnSchedule = deliverOnSchedule;
            return this;
        }

        public DeliveryBuilder timePeriod(TimePeriod timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public DeliveryBuilder userTimeZone(String userTimeZone) {
            this.userTimeZone = userTimeZone;
            return this;
        }

        public DeliveryBuilder serverTimeZone(String serverTimeZone) {
            this.serverTimeZone = serverTimeZone;
            return this;
        }

        public Delivery build() {
            return new Delivery(this.hour, this.minute, this.day, this.date, this.frequency, this.checkHoursPeriod, this.runEveryTime, this.runOnWeekends, this.considerWeekends, this.deliverOnSchedule, this.timePeriod, this.userTimeZone, this.serverTimeZone);
        }

        public String toString() {
            return "Delivery.DeliveryBuilder(hour=" + this.hour + ", minute=" + this.minute + ", day=" + this.day + ", date=" + this.date + ", frequency=" + (Object)((Object)this.frequency) + ", checkHoursPeriod=" + this.checkHoursPeriod + ", runEveryTime=" + this.runEveryTime + ", runOnWeekends=" + this.runOnWeekends + ", considerWeekends=" + this.considerWeekends + ", deliverOnSchedule=" + this.deliverOnSchedule + ", timePeriod=" + this.timePeriod + ", userTimeZone=" + this.userTimeZone + ", serverTimeZone=" + this.serverTimeZone + ")";
        }
    }
}

