/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.service.impl;

import com.moveworkforward.ao.AuditRepository;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.ao.impl.AbstractPluginSettingRepository;
import com.moveworkforward.component.GlobalSettingsManager;
import com.moveworkforward.model.AbstractGlobalSettings;
import com.moveworkforward.model.ConfigurationAudit;
import com.moveworkforward.service.ConfigurationAuditService;
import com.moveworkforward.service.OperationListener;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurationAuditService
implements ConfigurationAuditService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractConfigurationAuditService.class);
    private final AuditRepository auditRepository;
    private final GlobalSettingsManager globalSettingsManager;

    protected AbstractConfigurationAuditService(AuditRepository auditRepository, GlobalSettingsManager globalSettingsManager) {
        this.auditRepository = auditRepository;
        this.globalSettingsManager = globalSettingsManager;
    }

    @Override
    public synchronized List<ConfigurationAudit> getAll() {
        this.hasUserAdminPermissions();
        return this.auditRepository.getAll();
    }

    @Override
    public synchronized List<ConfigurationAudit> getByEntityAndOperation(String entityType, String operation) {
        this.hasUserAdminPermissions();
        return this.auditRepository.getByEntityAndOperation(entityType, operation);
    }

    @Override
    public int deleteAll() {
        this.hasUserAdminPermissions();
        return this.auditRepository.deleteAll();
    }

    @Override
    public List<ConfigurationAudit> deleteByEntityType(String entityType) {
        this.hasUserAdminPermissions();
        return this.auditRepository.deleteByEntityType(entityType);
    }

    @Override
    public void onOperationPerformed(Object configuration, OperationListener.OperationType operationType) {
        AbstractGlobalSettings globalSettings;
        if (!(configuration instanceof PluginEntity)) {
            log.debug("Nothing to audit");
            return;
        }
        AbstractGlobalSettings abstractGlobalSettings = globalSettings = configuration instanceof AbstractGlobalSettings ? (AbstractGlobalSettings)configuration : this.globalSettingsManager.getGlobalSettings();
        if (!globalSettings.isAuditSettingsEnabled()) {
            log.debug("Configuration audit is disabled");
            return;
        }
        ConfigurationAudit audit = new ConfigurationAudit();
        audit.setEntityId(((PluginEntity)configuration).getId());
        audit.setEntityType(AbstractPluginSettingRepository.getType(configuration.getClass()));
        audit.setConfiguration(configuration);
        audit.setLastModified(new Date());
        audit.setOperationType(operationType);
        audit.setUser(this.getUser());
        this.auditRepository.save(audit);
    }

    protected abstract String getUser();

    protected abstract void hasUserAdminPermissions();
}

