/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.rest;

import com.moveworkforward.model.PluginInfo;
import com.moveworkforward.service.impl.AbstractAtlassianPluginService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public abstract class AbstractCrossSellController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractCrossSellController.class);
    private final AbstractAtlassianPluginService atlassianPluginService;

    public AbstractCrossSellController(AbstractAtlassianPluginService atlassianPluginService) {
        this.atlassianPluginService = atlassianPluginService;
    }

    @GET
    public List<PluginInfo> getCrossSellPlugins() {
        String userKey = this.getUserKey();
        List<PluginInfo> result = new ArrayList<PluginInfo>();
        if (userKey == null || !this.atlassianPluginService.isDisplayForUser(userKey)) {
            return result;
        }
        try {
            String crossSell = this.getCrossSellValue();
            if (StringUtils.isBlank((CharSequence)crossSell)) {
                log.warn("Cross sell plugins are not specified");
                return result;
            }
            result = ((Stream)Arrays.stream(crossSell.split(";")).parallel()).map(this.atlassianPluginService::getPluginInfo).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        return result;
    }

    protected abstract String getCrossSellValue();

    protected abstract String getUserKey();

    @GET
    @Path(value="/close")
    public Map<String, Boolean> closeCrossSell() {
        String userKey = this.getUserKey();
        if (StringUtils.isNotBlank((CharSequence)userKey)) {
            this.atlassianPluginService.closeForUser(userKey);
            return Map.of("closed", true);
        }
        return Map.of("closed", false);
    }

    @GET
    @Path(value="/open")
    public Map<String, Boolean> openCrossSell() {
        String userKey = this.getUserKey();
        if (StringUtils.isNotBlank((CharSequence)userKey)) {
            this.atlassianPluginService.openForUser(userKey);
            return Map.of("opened", true);
        }
        return Map.of("opened", false);
    }
}

