/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.report;

import com.moveworkforward.model.AppVersion;
import com.moveworkforward.model.Product;
import com.moveworkforward.model.UpdateConfiguration;
import com.moveworkforward.model.VersionPayloadHolder;
import com.moveworkforward.report.ScheduledReportExecutor;
import com.moveworkforward.service.impl.AppVersionService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public interface AppVersionReportExecutor<T extends UpdateConfiguration<?>>
extends ScheduledReportExecutor {
    default public VersionPayloadHolder getPayloadDataByConfiguration(T configuration) {
        AppVersion installedOrNotifiedVersion;
        AppVersion lastAvailableVersion;
        VersionPayloadHolder payloadHolder = new VersionPayloadHolder();
        if (CollectionUtils.isNotEmpty(configuration.getProducts())) {
            for (Product product : configuration.getProducts()) {
                try {
                    lastAvailableVersion = this.getAppVersionService().getLastAvailableProductVersion(product.name());
                    installedOrNotifiedVersion = this.getAppVersionService().getLastNotifiedOrInstalledProductVersion(product.name());
                    if (!this.isNotificationRequired(installedOrNotifiedVersion, lastAvailableVersion, configuration.isOnlyMajorVersion())) continue;
                    payloadHolder.getProductVersions().add(lastAvailableVersion);
                }
                catch (Exception e) {
                    this.getLog().error(e.getMessage(), (Throwable)e);
                }
            }
        }
        for (UpdateConfiguration.PluginSource pluginSource : configuration.getPlugins()) {
            try {
                lastAvailableVersion = this.getAppVersionService().getLastAvailablePluginVersion(pluginSource.getKey());
                installedOrNotifiedVersion = this.getAppVersionService().getLastNotifiedOrInstalledPluginVersion(pluginSource.getKey());
                if (!this.isNotificationRequired(installedOrNotifiedVersion, lastAvailableVersion, configuration.isOnlyMajorVersion())) continue;
                payloadHolder.getPluginVersions().add(lastAvailableVersion);
            }
            catch (Exception e) {
                this.getLog().warn(e.getMessage(), (Throwable)e);
            }
        }
        return payloadHolder;
    }

    default public boolean isNotificationRequired(AppVersion currentVersion, AppVersion newVersion, boolean onlyMajorVersion) {
        if (newVersion == null || StringUtils.isBlank((CharSequence)newVersion.getVersion())) {
            return false;
        }
        if (currentVersion == null || StringUtils.isBlank((CharSequence)currentVersion.getVersion())) {
            return true;
        }
        if (onlyMajorVersion) {
            return new AppVersion.MajorVersionComparator().compare(currentVersion, newVersion) < 0;
        }
        return new AppVersion.MinorVersionComparator().compare(currentVersion, newVersion) < 0;
    }

    public Logger getLog();

    public AppVersionService getAppVersionService();
}

