/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.ao.impl;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.moveworkforward.ao.PluginRepository;
import com.moveworkforward.ao.PluginSettingRepository;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.ao.impl.AbstractCachedPluginRepository;
import com.moveworkforward.ao.impl.CachedRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCachedDecoratorPluginRepository<T extends PluginEntity>
implements PluginRepository<T>,
CachedRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractCachedDecoratorPluginRepository.class);
    protected CacheManager cacheManager;
    protected Cache<String, List<T>> cache;
    protected final PluginRepository<T> delegate;
    protected CacheSettings cacheSettings;

    public AbstractCachedDecoratorPluginRepository(PluginSettingRepository<T> repository, CacheManager cacheManager) {
        this.delegate = repository;
        this.cacheManager = cacheManager;
        this.cacheSettings = new CacheSettingsBuilder().remote().replicateViaInvalidation().maxEntries(500).expireAfterAccess(1440L, TimeUnit.MINUTES).build();
        this.cache = cacheManager.getCache(this.getClass().getName() + "." + this.delegate.getEntityType(), this::load, this.cacheSettings);
    }

    @Override
    public String getEntityType() {
        return this.delegate.getEntityType();
    }

    @Override
    public T save(T entity) {
        T result = this.delegate.save(entity);
        this.invalidateCache();
        return result;
    }

    @Override
    public T get(int id) {
        return (T)((PluginEntity)this.getData(String.valueOf(id), AbstractCachedPluginRepository.CacheStrategy.ID).stream().findFirst().orElse(null));
    }

    @Override
    public T delete(int id) {
        T result = this.delegate.delete(id);
        this.invalidateCache();
        return result;
    }

    @Override
    public T deleteByKey(String key) {
        T result = this.delegate.deleteByKey(key);
        this.invalidateCache();
        return result;
    }

    @Override
    public int count() {
        return this.delegate.count();
    }

    @Override
    public int count(String tagPattern) {
        return this.delegate.count(tagPattern);
    }

    @Override
    public List<T> getAll() {
        return this.getData(null, AbstractCachedPluginRepository.CacheStrategy.TYPE);
    }

    @Override
    public int deleteAll() {
        int count = this.delegate.deleteAll();
        this.invalidateCache();
        return count;
    }

    @Override
    public T getByKey(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return (T)((PluginEntity)this.getData(key, AbstractCachedPluginRepository.CacheStrategy.KEY).stream().findFirst().orElse(null));
    }

    @Override
    public List<T> deleteByTag(@NonNull String tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        List<T> result = this.delegate.deleteByTag(tag);
        this.invalidateCache();
        return result;
    }

    @Override
    public List<T> getByTag(@NonNull String tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        return this.getData(tag, AbstractCachedPluginRepository.CacheStrategy.TAG);
    }

    @Override
    public List<T> getByTag(String tag, int limit, int offset) {
        return this.delegate.getByTag(tag, limit, offset);
    }

    @Override
    public List<T> getAll(int limit, int offset) {
        return this.delegate.getAll(limit, offset);
    }

    @Override
    public List<T> getByTagLike(String tagPattern, int limit, int offset) {
        return this.delegate.getByTagLike(tagPattern, limit, offset);
    }

    @Override
    public void invalidateCache() {
        this.cache.removeAll();
    }

    @Nonnull
    protected List<T> getData(String key, AbstractCachedPluginRepository.CacheStrategy cacheStrategy) {
        String compositeKey = cacheStrategy.createCompositeKey(key);
        List result = null;
        boolean exception = false;
        try {
            result = (List)this.cache.get((Object)compositeKey);
        }
        catch (Exception e) {
            log.warn("Can't get data from cache, reload");
            exception = true;
        }
        if (exception || result == null) {
            this.cache.remove((Object)compositeKey);
            result = (List)this.cache.get((Object)compositeKey);
        }
        return Optional.ofNullable(result).map(ArrayList::new).orElse(new ArrayList());
    }

    @Nonnull
    protected List<T> load(@Nonnull String compositeKey) {
        List<T> result;
        Pair<AbstractCachedPluginRepository.CacheStrategy, String> pair = AbstractCachedPluginRepository.CacheStrategy.fromCompositeKey(compositeKey);
        switch ((AbstractCachedPluginRepository.CacheStrategy)((Object)pair.getKey())) {
            case ID: {
                result = this.loadById(Integer.parseInt((String)pair.getRight()));
                break;
            }
            case KEY: {
                result = this.loadByKey((String)pair.getRight());
                break;
            }
            case TAG: {
                result = this.loadByTag((String)pair.getRight());
                break;
            }
            default: {
                result = this.loadAll();
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void updateCacheConfiguration(int maxEntries, int expirationInMinutes) {
        log.info("Old cache size: {} ", (Object)this.cache.getKeys().size());
        log.info("Previous settings: max entries {}, expiration {}", (Object)this.cacheSettings.getMaxEntries(), (Object)this.cacheSettings.getExpireAfterAccess());
        log.info("New settings: max entries {}, expiration {}(min)", (Object)maxEntries, (Object)expirationInMinutes);
        CacheSettings newCacheSettings = new CacheSettingsBuilder().remote().maxEntries(maxEntries).expireAfterAccess((long)expirationInMinutes, TimeUnit.MINUTES).replicateViaInvalidation().build();
        Cache newCache = this.cacheManager.getCache(this.getClass().getName() + "." + this.delegate.getEntityType(), this::load, newCacheSettings);
        Cache<String, List<T>> oldCache = this.cache;
        this.cache = newCache;
        oldCache.removeAll();
        this.cacheSettings = newCacheSettings;
    }

    protected List<T> loadAll() {
        return this.delegate.getAll();
    }

    protected List<T> loadByTag(String tag) {
        return this.delegate.getByTag(tag);
    }

    protected List<T> loadByKey(String key) {
        return Optional.ofNullable(this.delegate.getByKey(key)).map(t -> new ArrayList<PluginEntity>(Collections.singletonList(t))).orElse(new ArrayList());
    }

    protected List<T> loadById(int id) {
        return Optional.ofNullable(this.delegate.get(id)).map(t -> new ArrayList<PluginEntity>(Collections.singletonList(t))).orElse(new ArrayList());
    }
}

