[@ww.textfield labelKey="msteams.webhookUrl" name="mswebhookUrl" value="${mswebhookUrl!}" required='true' /]
[@ww.textfield labelKey="msteams.channel" name="mschannel" value="${mschannel!}" required='false' maxlength=18 /]
[@ww.checkbox labelKey="msteams.includeImage" name="msincludeimage" value="${msincludeimage!?string}" /]
[@ww.checkbox labelKey="msteams.enabled" name="mstisenabled" value="${mstisenabled!?string}" required='false' /]
[@ww.checkbox labelKey="msteams.includeArtifacts" name="msIncludeArtifacts" value="${msIncludeArtifacts!?string}" required='false' /]
<br />
Microsoft Teams Build progress events
<br />
[@ww.checkbox labelKey="msteams.start.event" name="msBuildStarted" value="${msBuildStarted!?string}" required='false' /]
[@ww.checkbox labelKey="msteams.in.progress.event" name="msBuildInProgress" value="${msBuildInProgress!?string}" required='false' /]
[@ww.checkbox labelKey="msteams.finished.event" name="msBuildFinished" value="${msBuildFinished!?string}" required='false' /]

<script>
    const link = document.createElement("a");

    link.setAttribute("href", "https://help.moveworkforward.com/microsoft-teams/how-to-create-webhook-url-with-workflows-app");
    link.setAttribute("target", "_blank");
    link.setAttribute("style", "color: #0052CC; font-size: 12px; font-weight: 600; display: block;")
    link.textContent = "How to generate Webhook URL?"

    const getElementByIds = (ids) => {
        for (const id of ids) {
            const el = document.getElementById(id);
            if (el) return el;
        }
        return null;
    };

    let mswebhookUrlDesc = getElementByIds(["notification_mswebhookUrlDesc", "notificationsForm_mswebhookUrlDesc"]);
    if (mswebhookUrlDesc) {
        mswebhookUrlDesc.replaceWith(link);
    }
    const mswebhookUrl = getElementByIds(["notification_mswebhookUrl", "notificationsForm_mswebhookUrl"]);

    var regExps = [
        new RegExp('^https://(.)*.azure.com(.)*'),
        new RegExp('^https://(.)*.powerplatform.com(.)*')
    ];

    const isUrlValid = (url) => {
        if (!url) {
            return false;
        }
        return regExps.some(function (o) { return o.test(url); });
    };

    const processSubmit = () => {
        const submitButton = getElementByIds(["notification_save", "notificationsForm_save"]);
        if(!submitButton) {
            return;
        }
        submitButton.disabled = !isUrlValid(mswebhookUrl.value);
    };

    processSubmit();

    const validateValue = (event, message) => {
        const parentDiv = event.target.closest('div');

        // Remove all existing error messages in this parent div
        parentDiv.querySelectorAll('.control-form-error').forEach(el => el.remove());

        if(!isUrlValid(event.target.value)) {
            event.target.style.border = "1px solid #de350b !important";
            const errorMessage = document.createElement("div");
            errorMessage.setAttribute("class", "error control-form-error");
            errorMessage.setAttribute("style", "font-size: 12px; line-height: 1.66666666666667; color: #de350b;");
            errorMessage.textContent = message;
            event.target.insertAdjacentElement('afterend', errorMessage);
        } else {
            event.target.style.border = "1px solid #c1c7d0";
        }
        processSubmit();
    }

    const urlErrorMessage = "The URL is invalid. Please follow the link below to generate the correct one.";

    mswebhookUrl.addEventListener("input", function (e) { validateValue(e, urlErrorMessage, isUrlValid); });
    mswebhookUrl.addEventListener("paste", function (e) {
        setTimeout(() => validateValue(e, urlErrorMessage, isUrlValid), 0);
    });
</script>
