/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.util;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    public static final String HTTPS_SCHEME = "https";
    public static final String HTTP_SCHEME = "http";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEADER_VARY = "Vary";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String CONTENT_ENCODING_GZIP = "gzip";
    public static final String CONTENT_ENCODING_X_GZIP = "x-gzip";
    public static final String CONTENT_ENCODING_COMPRESS = "compress";
    public static final String CONTENT_ENCODING_X_COMPRESS = "x-compress";
    public static final String CONTENT_ENCODING_DEFLATE = "deflate";
    private static final String KEY_HTTP_PROXY_HOST = "http.proxyHost";
    private static final String KEY_HTTP_PROXY_PORT = "http.proxyPort";
    private static final String KEY_HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String KEY_HTTPS_PROXY_PORT = "https.proxyPort";
    private static final int HTTPS_PORT = 443;
    private static final int HTTP_PORT = 80;
    private static final Set<String> NON_MUTATIVE_HTTP_METHODS = new HashSet<String>(Arrays.asList("GET", "HEAD", "OPTIONS", "TRACE"));

    private HttpUtils() {
    }

    public static boolean isDefaultPort(String scheme, int port) {
        return port == 80 && scheme.equals(HTTP_SCHEME) || port == 443 && scheme.equals(HTTPS_SCHEME);
    }

    public static EndpointSpec getProxyForScheme(String scheme) {
        String password;
        String username;
        Integer proxyPort;
        String proxyHost;
        if (HTTPS_SCHEME.equalsIgnoreCase(scheme) || scheme == null) {
            proxyHost = System.getProperty(KEY_HTTPS_PROXY_HOST);
            proxyPort = Integer.getInteger(KEY_HTTPS_PROXY_PORT, 443);
            username = System.getProperty("https.proxyUser");
            password = System.getProperty("https.proxyPassword");
            if (proxyHost != null && proxyPort != null) {
                EndpointSpec endpointSpec = new EndpointSpec(proxyHost, proxyPort);
                if (username != null && password != null) {
                    endpointSpec.setUsername(username);
                    endpointSpec.setPassword(password);
                }
                return endpointSpec;
            }
        }
        if (HTTP_SCHEME.equalsIgnoreCase(scheme) || scheme == null) {
            proxyHost = System.getProperty(KEY_HTTP_PROXY_HOST);
            proxyPort = Integer.getInteger(KEY_HTTP_PROXY_PORT, 80);
            username = System.getProperty("http.proxyUser");
            password = System.getProperty("http.proxyPassword");
            if (proxyHost != null && proxyPort != null) {
                EndpointSpec endpointSpec = new EndpointSpec(proxyHost, proxyPort);
                if (username != null && password != null) {
                    endpointSpec.setUsername(username);
                    endpointSpec.setPassword(password);
                }
                return endpointSpec;
            }
        }
        return null;
    }

    public static boolean canMethodMutateState(String method) {
        return !NON_MUTATIVE_HTTP_METHODS.contains(method);
    }

    public static CloseableHttpClient createHttpClient(URI uri) {
        return HttpUtils.createHttpClient(uri, null);
    }

    public static CloseableHttpClient createHttpClient(URI uri, Integer timeout) {
        HttpClientBuilder builder;
        EndpointSpec proxyForScheme = HttpUtils.getProxyForScheme(uri.getScheme());
        if (proxyForScheme != null) {
            log.debug("Trying to use proxy");
            HttpHost proxy = new HttpHost(proxyForScheme.getHost(), proxyForScheme.getPort().intValue());
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            builder = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner);
            if (proxyForScheme.getUsername() != null && proxyForScheme.getPassword() != null) {
                log.debug("Setting up proxy credentials");
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxyForScheme.getHost(), proxyForScheme.getPort().intValue()), (Credentials)new UsernamePasswordCredentials(proxyForScheme.getUsername(), proxyForScheme.getPassword()));
                builder = builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            } else {
                log.debug("Proxy user name or password is not set");
            }
        } else {
            log.debug("No proxy is defined");
            builder = HttpClientBuilder.create().useSystemProperties();
        }
        if (timeout != null && timeout > 0) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
            builder.setDefaultRequestConfig(requestConfig);
        }
        return builder.build();
    }

    public static class EndpointSpec {
        private final String host;
        private final Integer port;
        private String username;
        private String password;

        public EndpointSpec(String host, Integer port) {
            this.host = host;
            this.port = port;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getHost() {
            return this.host;
        }

        public Integer getPort() {
            return this.port;
        }
    }
}

