/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Generated;
import org.joda.time.DurationFieldType;
import org.joda.time.Period;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true, value={"period"})
public class TimePeriod
implements Cloneable {
    private static final int DAYS_IN_WEEK = 7;
    private int interval;
    private TimeUnit timeUnit = TimeUnit.DAY;

    public Period getPeriod() {
        if (this.timeUnit == null) {
            throw new IllegalArgumentException("Time unit is not set");
        }
        switch (this.timeUnit) {
            case MINUTE: {
                return Period.minutes((int)this.interval);
            }
            case HOUR: {
                return Period.hours((int)this.interval);
            }
            case DAY: {
                return Period.days((int)this.interval);
            }
            case WEEK: {
                return Period.days((int)(this.interval * 7));
            }
            case MONTH: {
                return Period.months((int)this.interval);
            }
            case YEAR: {
                return Period.years((int)this.interval);
            }
        }
        throw new IllegalArgumentException("Unknown time unit: " + this.timeUnit);
    }

    public boolean isSet() {
        return this.interval > 0 && this.timeUnit != null;
    }

    public TimePeriod clone() {
        return (TimePeriod)super.clone();
    }

    @Generated
    public int getInterval() {
        return this.interval;
    }

    @Generated
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Generated
    public void setInterval(int interval) {
        this.interval = interval;
    }

    @Generated
    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    @Generated
    public String toString() {
        return "TimePeriod(super=" + super.toString() + ", interval=" + this.interval + ", timeUnit=" + this.timeUnit + ")";
    }

    @Generated
    public TimePeriod() {
    }

    @Generated
    public TimePeriod(int interval, TimeUnit timeUnit) {
        this.interval = interval;
        this.timeUnit = timeUnit;
    }

    public static enum TimeUnit {
        YEAR(DurationFieldType.years()),
        MONTH(DurationFieldType.months()),
        WEEK(DurationFieldType.weeks()),
        DAY(DurationFieldType.days()),
        HOUR(DurationFieldType.hours()),
        MINUTE(DurationFieldType.minutes());

        private final DurationFieldType durationFieldType;

        private TimeUnit(DurationFieldType durationFieldType) {
            this.durationFieldType = durationFieldType;
        }

        @Generated
        public DurationFieldType getDurationFieldType() {
            return this.durationFieldType;
        }
    }
}

