/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.license;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LicenseInfoProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseInfoProvider.class);
    public static final String DESCRIPTION = "Description";
    public static final String PARTNER = "Partner";
    public static final String ACTIVE = "Active";
    public static final String DATA_CENTER = "Data Center";
    public static final String EVALUATION = "Evaluation";
    public static final String SUBSCRIPTION = "Subscription";
    public static final String UNLIMITED_EDITION = "Unlimited Edition";
    public static final String VALID = "Valid";
    public static final String AUTO_RENEWAL = "Auto Renewal";
    public static final String SERVER_ID = "Server Id";
    public static final String PLUGIN_NAME = "Plugin Name";
    public static final String ORGANIZATION = "Organization";
    public static final String LICENSE_TYPE_DESCRIPTION_KEY = "License Type Description Key";
    public static final String LICENSE_VERSION = "License Version";
    public static final String LICENSE_TYPE = "License Type";
    public static final String EXPIRY_DATE = "Expiry Date";
    public static final String CREATION_DATE = "Creation Date";
    public static final String TIME_BEFORE_EXPIRY = "Time before Expiry";
    public static final String MAXIMUM_NUMBER_OF_USERS = "Maximum Number of Users";
    public static final String EDITION = "Edition";
    public static final String ERROR = "Error";
    private final PluginLicenseManager pluginLicenseManager;

    @Autowired
    public LicenseInfoProvider(@ComponentImport PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public Map<String, Object> getLicenseInfo() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            this.addValue(properties, DESCRIPTION, pluginLicense.getDescription());
            this.addValue(properties, PARTNER, pluginLicense.getPartner());
            this.addValue(properties, ACTIVE, this.getMethodSafe(pluginLicense, "isActive"));
            this.addValue(properties, DATA_CENTER, this.getMethodSafe(pluginLicense, "isDataCenter"));
            this.addValue(properties, EVALUATION, pluginLicense.isEvaluation());
            this.addValue(properties, SUBSCRIPTION, pluginLicense.isSubscription());
            this.addValue(properties, UNLIMITED_EDITION, this.getMethodSafe(pluginLicense, "isUnlimitedEdition"));
            this.addValue(properties, VALID, pluginLicense.isValid());
            this.addValue(properties, AUTO_RENEWAL, this.getMethodSafe(pluginLicense, "isAutoRenewal"));
            this.addValue(properties, SERVER_ID, pluginLicense.getServerId());
            this.addValue(properties, PLUGIN_NAME, pluginLicense.getPluginName());
            this.addValue(properties, ORGANIZATION, pluginLicense.getOrganization());
            this.addValue(properties, LICENSE_TYPE_DESCRIPTION_KEY, this.getMethodSafe(pluginLicense, "getLicenseTypeDescriptionKey"));
            this.addValue(properties, LICENSE_VERSION, pluginLicense.getLicenseVersion());
            this.addValue(properties, LICENSE_TYPE, pluginLicense.getLicenseType());
            this.addValue(properties, EXPIRY_DATE, pluginLicense.getExpiryZonedDate().orElse(null));
            this.addValue(properties, CREATION_DATE, pluginLicense.getCreationZonedDate());
            this.addValue(properties, TIME_BEFORE_EXPIRY, pluginLicense.getDurationBeforeExpiry().orElse(null));
            this.addValue(properties, MAXIMUM_NUMBER_OF_USERS, pluginLicense.getMaximumNumberOfUsers());
            this.addValue(properties, EDITION, pluginLicense.getEdition().getOrElse((Object)null));
            this.addValue(properties, ERROR, pluginLicense.getError().getOrElse((Object)null));
        }
        this.addValue(properties, "Plugin Key", this.pluginLicenseManager.getPluginKey());
        return properties;
    }

    private void addValue(Map<String, Object> properties, String key, Object value) {
        value = value == null ? "Undefined" : value;
        properties.put(key, value);
    }

    private Object getMethodSafe(PluginLicense pluginLicense, String methodName) {
        if (pluginLicense != null) {
            try {
                Method method = PluginLicense.class.getMethod(methodName, new Class[0]);
                Object result = method.invoke((Object)pluginLicense, new Object[0]);
                if (result instanceof Option) {
                    Option option = (Option)result;
                    return option.isDefined() ? option.get() : null;
                }
                return result;
            }
            catch (Exception e) {
                log.warn("License method {} is not found", (Object)methodName);
            }
        }
        return null;
    }

    public String getPluginKey() {
        return this.pluginLicenseManager.getPluginKey();
    }
}

