[@ww.textfield labelKey="msteams.webhookUrl" name="mswebhookUrl" value="${mswebhookUrl!}" required='true'/]
<br />
[@ww.textarea labelKey="msteams.message" name="msMessage" value="${msMessage!}" class="" style="height: 120px; width: 90%; max-width: 500px;" required="true"/]


<script>
    const link = document.createElement("a");

    link.setAttribute("href", "https://help.moveworkforward.com/microsoft-teams/how-to-create-webhook-url-with-workflows-app");
    link.setAttribute("target", "_blank");
    link.setAttribute("style", "color: #0052CC; font-size: 12px; font-weight: 600; display: block;")
    link.textContent = "How to generate Webhook URL?"

    const getElementByIds = (ids) => {
        for (const id of ids) {
            const el = document.getElementById(id);
            if (el) return el;
        }
        return null;
    };

    const mswebhookUrlDesc = document.getElementById("mswebhookUrlDesc");
    if (mswebhookUrlDesc) {
        mswebhookUrlDesc.replaceWith(link);
    }
    const mswebhookUrl = document.getElementById("mswebhookUrl");
    const msMessage = document.getElementById("msMessage");


    var regExps = [
        new RegExp('^https://(.)*.azure.com(.)*'),
        new RegExp('^https://(.)*.powerplatform.com(.)*')
    ];

    const isUrlValid = (url) => {
        if (!url) {
            return false;
        }
        return regExps.some(function (o) { return o.test(url); });
    };

    const processSubmit = () => {
        const submitButton = getElementByIds( ["createTask_save", "updateTask_save"]);
        if(!submitButton) {
            return;
        }
        submitButton.disabled = !isUrlValid(mswebhookUrl.value) || !msMessage.value;
    };

    processSubmit();

    const validateValue= (event, message, validationFunction) => {
        const errorElement = document.getElementById(event.target.id + "_error");
        if(!event.target.value || (validationFunction && !validationFunction(event.target.value))) {
            if(errorElement) {
                return;
            }
            event.target.style.border = "1px solid #de350b !important";
            const errorMessage = document.createElement("div");
            errorMessage.setAttribute("class", "error control-form-error")
            errorMessage.setAttribute("id", event.target.id + "_error");
            errorMessage.textContent = message;
            event.target.insertAdjacentElement('afterend', errorMessage);
        } else {
            event.target.style.border = "1px solid #c1c7d0";
            if (errorElement) {
                errorElement.remove();
            }
        }
        processSubmit();
    }

    const urlErrorMessage = "The URL is invalid. Please follow the link below to generate the correct one.";
    const messageErrorMessage = "The message cannot be empty.";

    mswebhookUrl.addEventListener("input", function (e) { validateValue(e, urlErrorMessage, isUrlValid); });
    mswebhookUrl.addEventListener("paste", function (e) {
        setTimeout(() => validateValue(e, urlErrorMessage, isUrlValid), 0);
    });
    msMessage.addEventListener("input", function (e) { validateValue(e, messageErrorMessage); });
    msMessage.addEventListener("paste", function (e) {
        setTimeout(() => validateValue(e, messageErrorMessage), 0);
    });
</script>