/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.v2.service.impl;

import com.moveworkforward.model.User;
import com.moveworkforward.service.OperationListener;
import com.moveworkforward.v2.ao.PluginRepository;
import com.moveworkforward.v2.model.IdModel;
import com.moveworkforward.v2.service.ConfigurationService;
import com.moveworkforward.v2.validation.RecordValidator;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurationService<T extends IdModel>
implements ConfigurationService<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractConfigurationService.class);
    protected final PluginRepository pluginRepository;
    protected final RecordValidator recordValidator;
    protected final Class<T> persistentClass;
    private final List<OperationListener> operationListeners;

    public AbstractConfigurationService(PluginRepository pluginRepository, RecordValidator recordValidator, List<OperationListener> operationListeners) {
        this.pluginRepository = pluginRepository;
        this.recordValidator = recordValidator;
        this.operationListeners = operationListeners;
        this.persistentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    @Override
    public T save(T target) {
        IdModel existingEntity;
        OperationListener.OperationType operationType;
        this.validate(target);
        OperationListener.OperationType operationType2 = operationType = target.getId() == null || target.getId() == 0 ? OperationListener.OperationType.CREATE : OperationListener.OperationType.UPDATE;
        if (OperationListener.OperationType.UPDATE.equals((Object)operationType) && (existingEntity = (IdModel)this.pluginRepository.get(target.getId(), this.persistentClass)) != null) {
            this.recordValidator.checkWritePermissions(existingEntity);
        }
        this.recordValidator.checkWritePermissions(target);
        IdModel result = (IdModel)this.pluginRepository.save(target);
        this.callOperationListeners(result, operationType);
        return (T)result;
    }

    @Override
    public T get(int id) {
        IdModel result = (IdModel)this.pluginRepository.get(id, this.persistentClass);
        if (result == null) {
            throw new RuntimeException("Record is not found by id: " + id);
        }
        this.recordValidator.checkReadPermissions(result);
        return (T)result;
    }

    @Override
    public T delete(int id) {
        IdModel result = (IdModel)this.pluginRepository.get(id, this.persistentClass);
        if (result == null) {
            throw new RuntimeException("Record is not found by id: " + id);
        }
        this.recordValidator.checkDeletePermissions(result);
        this.callOperationListeners(result, OperationListener.OperationType.DELETE);
        return (T)((IdModel)this.pluginRepository.delete(id, this.persistentClass));
    }

    @Override
    public List<T> getAll() {
        boolean hasTagPermission = this.recordValidator.hasTagPermission(null, null);
        List<T> result = this.pluginRepository.getAll(this.persistentClass);
        result = hasTagPermission ? result : this.filter(result);
        return result;
    }

    @Override
    public List<T> getByTag(String tag, String level) {
        boolean hasTagPermission = this.recordValidator.hasTagPermission(tag, level);
        List<T> result = this.pluginRepository.getByTag(tag, this.persistentClass);
        result = hasTagPermission ? result : this.filter(result);
        return result;
    }

    protected void validate(T target) {
        this.recordValidator.validate(target);
    }

    protected List<T> filter(List<T> entities) {
        User user = this.recordValidator.getCurrentUser();
        return entities.stream().filter((? super T t) -> this.recordValidator.hasReadPermissions(t, user)).collect(Collectors.toList());
    }

    protected void callOperationListeners(T result, OperationListener.OperationType operationType) {
        if (CollectionUtils.isNotEmpty(this.operationListeners)) {
            this.operationListeners.forEach(listener -> {
                try {
                    listener.onOperationPerformed(result, operationType);
                }
                catch (Exception e) {
                    log.error("Error during operation {} listener call", listener.getClass(), (Object)e);
                }
            });
        }
    }
}

